//====================================================== sysfunctions.h========================================================

void head(void)
{
  time_t tnow;

  time(&tnow);
  tmnow = localtime(&tnow);  
  printf("\n%02d.%02d.%04d                 [SysInfo Ver.: %s]                     %02d:%02d \n", tmnow -> tm_mday,
                                                                                           tmnow -> tm_mon + 1,
                                                                                           tmnow -> tm_year + 1900,
                                                                                           PRGVERSION,
                                                                                           tmnow -> tm_hour,
                                                                                           tmnow -> tm_min);
  printf("==========================================================================\n\n");
} //END head


// #################################################################################################################


void save_custom_Variables(int var) 
{  
 char CPUWarnTempSave[5];
 

 // creating a new plain setting-file
  system("rm -rf /tmp/sysinfo.save");
  system("touch /tmp/sysinfo.save");            /// ###bookmark1###       <---[!]
  
 //opening the file
  save_Variables_file=fopen(SAVEFILE_PATH, "w");
  
  
  
//---CPUWARNTEMP----

 //saving the CPU Warning Temperature in the Sysinfo-Settingfile
  fputs("CPU Warning Temp in C: ", save_Variables_file );
  
 //converting int to string
  sprintf(CPUWarnTempSave, "%d", CPU_WarningTemp); 
 
  fputs(CPUWarnTempSave, save_Variables_file);
  fputs("\n", save_Variables_file);
    
//--END CPUWARNTEMP---- 
  

  
 //closing the setting-file   
  fclose(save_Variables_file);   
}// save_custom_Variables


// #################################################################################################################


void get_custom_Variables(void)
{
 
 //Enter number of settings to get
 int SettingsToGet = 1;  
 

 get_Variables_file=fopen("/tmp/sysinfo.save", "r");
 
 if(NULL != get_Variables_file)
 {
   
   fgets(GetCPUWarnTemp, 35, get_Variables_file );  //Get CPU Warning Temperature
   commit_GetCPUWarnTemp();
   
   
   
   // add anotherone here!
   
 }
 else 
 {
   printf("No config-file found or config-file corrupt!\t\t\t\t\t\t\t[WARNING]\n* Please type \"sysinfo_config\" \
   to create a new config-file\n\n");
   
   //end program if no config-file was found
   exit(0);
 }
}


// #################################################################################################################


void uptime(void)
{
  unsigned int uptime_unsorted = 0;
  unsigned char c;
  unsigned int DD;
  unsigned int HH;
  unsigned int MM;
//unsigned int SS; //uptime seconds
  
  uptime_file=fopen("/proc/uptime","r");

  if(NULL != uptime_file)
  {  
    while((c=fgetc(uptime_file))!= '.')
      {
        unsigned int i;
        i = atoi(&c);
        uptime_unsorted = (uptime_unsorted * 10) + i;
      }
  //SS = uptime_unsorted % 60; //seconds
    MM = uptime_unsorted / 60 % 60;
    HH = uptime_unsorted / 60 / 60 % 24;
    DD = uptime_unsorted / 60 / 60 / 24;
    fclose(uptime_file);
    printf("Uptime:\t\tdays %i, %02i:%02i\n",DD,HH,MM);
  }
  else
  {
    printf("Open file \"proc/uptime\" failed!\n");
  }

} //end UPTIME


// #################################################################################################################


void kernel_v(void)
{
  char Linux_v[35];
  kernel_file=fopen("/proc/sys/kernel/osrelease", "r");
  
  if(NULL != kernel_file)
  { 
    fgets(Linux_v, 35, kernel_file);
    printf("Linux:\t\t%s",Linux_v); 
    
    if(strstr(Linux_v, "2.6") == NULL )
      old_kernel = TRUE;
    
    fclose(kernel_file);
  }
  else
  {
    
    //If /proc/sys/kernel/osrelease wasn't found (creating a new one)
    system ("uname -r > /tmp/uname"); 
    kernel_file=fopen("/tmp/uname", "r");
    fgets(Linux_v, 35, kernel_file);
    printf("Linux:\t\t%s",Linux_v);
    
    if(strstr(Linux_v, "2.6") == NULL )
      old_kernel = TRUE;
    
    fclose(kernel_file);         
  }
} //END detect Kernel version and output


// #################################################################################################################


void memory(void)
{
  char MemTotal[35];
  char MemFree[35];
  mem_file=fopen("/proc/meminfo","r");
  
  if(NULL != mem_file)
  {
    if(old_kernel == TRUE)
    {
      unsigned char trash[100];
      unsigned int i;
      for(i=3; i>0 ; i--)
        fgets(trash, 100, mem_file);
    }
    
    fgets(MemTotal, 35, mem_file);
    fgets(MemFree, 35, mem_file);
    printf("%s",MemTotal);
    printf("%s",MemFree);
    fclose(mem_file);
  }
  else
  {
    printf("Open file \"/proc/meminfo\" failed!\n");
  }
}//END memory


// #################################################################################################################


void cputemp(void)
{ 
  char cputemp_string[35];
  char num[] ="0123456789";
  char cputemp_char;
  unsigned int temp = 0;
  unsigned int tempbegin;
  unsigned int tempend;
  unsigned int cputemp = 0;
  char path[45];
  
  if(1 > device_flag)
  {
    cputemp_file=fopen("/sys/bus/i2c/devices/0-0290/temp1_input", "r");
    if(NULL != cputemp_file)
    {
      device_flag = 1;
      fclose(cputemp_file);
    }
  
    cputemp_file=fopen("/proc/acpi/thermal_zone/ATF0/temperature", "r");
    if(NULL != cputemp_file)
    {
      device_flag = 2;
      fclose(cputemp_file);
    }
  
    cputemp_file=fopen("/proc/acpi/thermal_zone/THRM/temperature","r");
    if(NULL != cputemp_file)
    {
      device_flag =3;
      fclose(cputemp_file);
    }
  }//END if  
  switch (device_flag)
  {
    case 3: strncpy (path,"/proc/acpi/thermal_zone/THRM/temperature",sizeof(path));
            break;
    case 2: strncpy(path, "/proc/acpi/thermal_zone/ATF0/temperature", sizeof(path));
            break;
    case 1: break;
    default: printf("CPU-Temp:\tNo sensors found!\n");   
     
  }
  
  if(1 < device_flag)
  {
    cputemp_file=fopen(path, "r");
    fgets(cputemp_string, 35, cputemp_file);
    
  //strpbrk(cputemp, num);
  //temp = atoi(&cputemp);
       
    tempbegin = strcspn(cputemp_string, num);
    tempend = strcspn(cputemp_string, "C");
    
    int i = tempbegin;
    for (; i < (tempend-1); i++)
    {
      cputemp_char = cputemp_string[i];
      temp = (((int)cputemp_char)- 48);
      cputemp = (cputemp * 10) + temp;
    }
    
    //printf("%d", CPU_WarningTemp);
    
    if (cputemp < CPU_WarningTemp)
    {   
      printf("CPU-Temp:\t%d C\n",cputemp);
    }  
    else  
    {
      printf("CRITICAL CPU TEMPERATURE !!! (%d C)\n", cputemp);
    }
    
     fclose(cputemp_file);
     
  }
  else if(1 == device_flag)
    {
      cputemp_file=fopen("/sys/bus/i2c/devices/0-0290/temp1_input", "r");
      fgets(cputemp_string, 7, cputemp_file);
      int i = 0;
      for( ;i < 5; i++)
      {
        cputemp_char = cputemp_string[i];
        temp = (((int)cputemp_char)- 48);
        cputemp = (cputemp * 10) + temp;
      }
      cputemp /= 1000;
      if (cputemp < CPU_WarningTemp)
      {   
        printf("CPU-Temp:\t%d C\n",cputemp);
      }  
      else  
      {
        printf("CRITICAL CPU TEMPERATURE !!! (%d C)\n", cputemp);
      }
      
      fclose(cputemp_file);
    }
   
} //END cputemp


// #################################################################################################################
 

void commit_GetCPUWarnTemp(void)
{
  unsigned int WarnTempbegin = 0;
  unsigned int i;
  unsigned int WarnTempend;
  unsigned char WarnTempChar; 
  unsigned int temp;
  unsigned int tempnew = 0;
  
  WarnTempbegin = strcspn( GetCPUWarnTemp, ":") + 2;
  WarnTempend = WarnTempbegin + 2;    // Two digits
 
  
  for (i = WarnTempbegin ; i < (WarnTempend); i++)
  {
    WarnTempChar = GetCPUWarnTemp[i];
    temp = (((int)WarnTempChar)- 48);
    tempnew = (tempnew * 10) + temp;
   }
  
   CPU_WarningTemp = tempnew;      
}


// #################################################################################################################


void cpumodel(void)
{
  if (cpumodel_check == TRUE) // already ascertained the model?
  {
    char cpumodel[50];
    char cpuinfo[50];
    char trash[100];
    int cpubegin;
    
    cpumodel_file=fopen("/proc/cpuinfo", "r");
  
    if(NULL != cpumodel_file)
    {
      int i;
      for (i = 4; i > 0; i--)
        fgets(trash, 100, cpumodel_file);
    
      
      fgets(cpuinfo, 50, cpumodel_file);
      fclose(cpumodel_file);
  
      //Allocating the first CPU-Model Character
      cpubegin = strcspn( cpuinfo, ":") + 2;
      
  
      i = cpubegin; 
      for (; cpubegin < 50; cpubegin ++)
	cpumodel[cpubegin - i] = cpuinfo[cpubegin];
	
    
      //Display the CPU-Model
      printf("CPU-Model:\t%s", cpumodel);
    }
    else
    {
      fclose(cpumodel_file);
      printf("Open file \"/proc/cpuinfo\" failed!\n");
    }
    
    cpumodel_check = FALSE;
    strcpy(cpumodel_save , cpumodel); 
  }
  
  else
    printf("CPU-Model:\t%s", cpumodel_save); //Printing CPU - Model from Memory
    
}// END cpumodel


// #################################################################################################################


void cpu_load(void)
{
  FILE *stat;
  int user_new, nice_new, system_new, idle_new, wa_new, hi_new, si_new;
  int user = 0, nice = 0, system=0, idle=0, wa=0, hi=0, si = 0;
  char cpu[6];
  int i;
  
    stat=fopen("/proc/stat","r");
    fscanf(stat,"%s%d%d%d%d%d%d%d\n",cpu,&user_new,&nice_new,&system_new,&idle_new,&wa_new,&hi_new,&si_new);
    user = user_new - user_old;
    nice = nice_new - nice_old;
    system = system_new - system_old;
    idle = idle_new - idle_old;
    wa = wa_new - wa_old;
    hi = hi_new - hi_old;
    si = si_new - si_old;
    
    if(1 < updatetime)
    {
      user /= updatetime;
      nice /= updatetime;
      system /= updatetime;
      idle /= updatetime;
      wa /= updatetime;
      hi /= updatetime;
      si /= updatetime;
    }
    if(0 != user_old)
      printf("CPU-Load:\tuser:\t%2d\%\n\t\tsys:\t%2d\%\n\t\tnice:\t%2d\%\n\t\tidle:\t%2d\%\n",user,system, nice, idle);
//       printf("CPU-Load:\tuser:\t%d\%\tsys:\t%d\%\n\t\tnice:\t%d\%\tidle:\t%d\%\n\t\twa:\t%d\%\thi:\t%d\%\n\t\tsi:\t%d\% \n",user,system, nice, idle, wa, hi, si);
    user_old = user_new;
    nice_old = nice_new;
    system_old = system_new;
    idle_old = idle_new;
    wa_old = wa_new;
    hi_old = hi_new;
    si_old = si_new;
    fclose(stat);
}


// #################################################################################################################


void chk_SysinfoDir(void)
{  
  sysinfo_dir = fopen(SYSINFODIR_PATH, "r");
  
  if (NULL == sysinfo_dir)
  {
    //Creating new Sysinfo Directory
    system("mkdir /tmp/sysinfo/");
    system("touch /tmp/sysinfo/.keep");
  }  
}

void devices(void)
{
  
  system("df -h");
  //other informations here!
}

