//=========================================sysinfo.c============================================
/*
 * SysInfo 
 *--------------------
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU GeneCPUral Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */


  
	/********************************************************************
          Currently active programmers:     Philipp Rosenberger
	                                    Maic Bergmann
       **********************************************************************/

 
       
             
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#define DEFAULTUPDATETIME 3
#define PRGVERSION "0.0.3a"
#define clrscr() printf("\x1B[2J") //define a clearscreen for linux
#define TRUE 1
#define FALSE 0 
#define CPU_WARNINGTEMP 75
#define SAVEFILE_PATH "/tmp/sysinfo.save"   // !!! take a look @ if setting file doesn't exist (search for ###bookmark1###)  
#define SYSINFODIR_PATH "/tmp/sysinfo/.keep"


//===============================================DEKLARATIONS===============================================================


//deklarations of option-switch funktions
void switch_help(void);
void switch_verbose(void);
void switch_foobar(void);
void switch_version(void);
void switch_updatetime(void);
void switch_cputemp(void);
void switch_setWarnTemp(void);


//deklarations of output funktions
void head(void);
void uptime(void);
void kernel_v(void);
void cpumodel(void);
void cputemp(void);
void memory(void);
void save_custom_Variables(int var);
void get_custom_Variables(void);
void commit_GetCPUWarnTemp(void);
void cpu_load(void);
void chk_SysinfoDir(void);
void devices(void);


//File-Handles
FILE *sysinfo_dir, *mem_file, *version_file, *kernel_file, *uptime_file, *cputemp_file, *cpumodel_file, *save_Variables_file,\
*get_Variables_file;


//Global Variables
unsigned int CPU_WarningTemp = CPU_WARNINGTEMP;
unsigned int start      = FALSE;   //if set the main programm will start
unsigned int updatetime = DEFAULTUPDATETIME;
unsigned int old_kernel = FALSE;
unsigned int cputemp_flag = FALSE;
unsigned int cpumodel_check = TRUE;
unsigned int device_flag = 0;
unsigned int user_old=0, nice_old=0, system_old=0, idle_old=0, wa_old=0, hi_old=0, si_old=0;

unsigned char cpumodel_save[50];
unsigned char GetCPUWarnTemp[35];


//structures
struct tm *tmnow;


//including the custom headerfiles
#include "sysswitchfunctions.h"
#include "sysfunctions.h"
#include "sysmain.h"


