    /**************************************************************************
    *   Copyright (C) 2004 by Philipp Rosenberger                             *
    *   p-rosenberger@web.de                                                  *
    *                                                                         *
    *   This program is free software; you can redistribute it and/or modify  *
    *   it under the terms of the GNU General Public License as published by  *
    *   the Free Software Foundation; either version 2 of the License, or     *
    *   (at your option) any later version.                                   *
    *                                                                         *
    *   This program is distributed in the hope that it will be useful,       *
    *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
    *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
    *   GNU General Public License for more details.                          *
    *                                                                         *
    *   You should have received a copy of the GNU General Public License     *
    *   along with this program; if not, write to the                         *
    *   Free Software Foundation, Inc.,                                       *
    *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
    ***************************************************************************/

 
       /********************************************************************
         Currently active programmers:     Philipp Rosenberger (iluminat23) 
       ********************************************************************/

 
       
             
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <ncurses.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <pwd.h>
#include <limits.h>
#include <errno.h>
#include <sys/utsname.h>
#include "shit.h"

#define DEFAULTUPDATETIME 1
#define PRGVERSION "0.0.5.1"
#define AUTHOR "Philipp Rosenberger"
#define CPU_WARNINGTEMP 75


//===============================================DEKLARATIONS=================================================


//deklarations of option-switch funktions
void switch_help(char*);
void switch_about(void);
void switch_foobar(void);
void switch_version(void);
void switch_updatetime(void);
unsigned short switch_cputemp(void);
short switch_setWarnTemp(void);
unsigned short switch_disk_free(void);
unsigned short switch_ppp(void);
unsigned short switch_clear_ppp(void);
unsigned short switch_cpu_load_verbose(void);
unsigned short switch_mem_verbose(void);
unsigned short switch_net_verbose(void);
unsigned short switch_swap(void);


//Global Variables
unsigned int updatetime = DEFAULTUPDATETIME;
unsigned char first_run = TRUE,  start = FALSE, *homedir = 0;

unsigned long long *net_ptr_volume_down = 0, *net_ptr_volume_up = 0;                     //values from the volume-log file
unsigned long long *net_ptr_total_rx_volume=0, *net_ptr_total_tx_volume = 0;             //the current total volume 
unsigned int net_rx_new = 0, net_tx_new = 0, *net_ptr_rx_old = 0, *net_ptr_tx_old = 0;   //new and old values from proc
unsigned int *net_ptr_rx_first = 0, *net_ptr_tx_first = 0;                               //first value from proc
float *net_ptr_rx = 0, *net_ptr_tx = 0;                                                  //new - old value

unsigned long long *ppp_ptr_volume_down=0, *ppp_ptr_volume_up=0;                         //values from the volume-log file
unsigned long long *ppp_ptr_total_rx_volume=0, *ppp_ptr_total_tx_volume=0;               //the current total volume 
unsigned int ppp_rx_new = 0, ppp_tx_new = 0, *ppp_ptr_rx_old=0, *ppp_ptr_tx_old=0;       //new and old values from proc
unsigned int *ppp_ptr_rx_first=0, *ppp_ptr_tx_first=0;                                   //first value from proc
unsigned int *ppp_ptr_rx=0, *ppp_ptr_tx=0;                                               //new - old value

unsigned short net_num_max, ppp_num_max;

//===================================================SWITCH-FUNCTIONS======================================================

//SWITCH HELP output options
void switch_help(char *exec_name)
{
  //drawing the help-menu
  printf("\n\n>>>shit is a versatile infomonitor<<<\n");
  printf("  usage: %s [option 0] [option 1]...[option n] \n\n", exec_name);
  printf("  option          long option              meaning\n");
  printf("----------------------------------------------------------------------------------\n");
  printf("  -h, -?           --help                  shows this message\n");
  printf("                   --about                 shows some infos about ShIT\n");
  printf("  -v               --version               shows current Version\n");
  printf("  -f               --foobar                shows FooBar\n");
  printf("  -u               --updatetime            set new updatetime (default: %d sec)\n", DEFAULTUPDATETIME);
  printf("  -ct              --cputemp               shows CPU-Temp in C \n");
  printf("  -st              --settemp               set CPU Warning Temperature (default: %d C)\n", CPU_WARNINGTEMP);
  printf("  -df              --diskfree              shows used disk space\n");
  printf("  -ppp                                     aktivate ppp-load and log\n");
  printf("  -pc              --ppp-clr               clears ppp_volume log-file\n");
  printf("  -cv              --cpu-verbose           verbose cpu-load information\n");
  printf("  -mv              --mem-verbose           verbose memory information\n");
  printf("                   --swap                  aktivate swap-use\n");
  printf("  -sv              --swap-verbose          verbose swap information\n");
  printf("  -nv              --net-verbose           verbose network information\n");
  //program does not start if help or wrong option is set
  exit(0);
} //END HELP


// #################################################################################################################

void switch_about(void)
{
  printf("\n>>> ShIT - Shell Information Tool <<<\n\n");
  printf("ShIT %s - is a versatile infomonitor\n\n", PRGVERSION);
  printf("Developer: Philipp Rosenberger (iluminat23)\n");
  printf("homepage:  http://iluminat23.homelinux.org/shit/\n\n");
  printf("ThanksTo:  Fabian Gorsler (sirmoloch)\n");
  printf("           \tFor extensive testing.\n");
  printf("           Maic Bergmann\n");
  printf("           \tFor the idea and some code.\n");
  printf("\nCopyright (C) 2004, Philipp Rosenberger.\n");
  printf("This program is distributed under the terms of the GPL v2.\n\n");
  printf("This is free software there is NO warranty;\n");
  printf("not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n\n");
  printf("Report bugs to <iluminat23@arcor.de>.\n\n");
  
  exit(0);
}

// #################################################################################################################

void switch_foobar(void)
{
  printf(">> foobar ;)\n");
  
  exit(0);
} //END switch_foobar


// #################################################################################################################


void switch_version(void)
{
  printf("ShIT - ShellInformationTool %s\n", PRGVERSION);
  printf("Written by %s.\n\n",AUTHOR);
  printf("Copyright (C) 2004 %s.\n", AUTHOR);
  printf("This is free software; see the source for copying conditions.  There is NO\n");
  printf("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n");
  exit(0);
} //END switch_version


// #################################################################################################################


void switch_updatetime(void)
{
  printf("Please enter time (sec) between update: ");
  scanf("%10i", &updatetime);
  if(1 > updatetime)
    updatetime = 1;
  start = TRUE;
} //END switch_updatetime


// #################################################################################################################


unsigned short switch_cputemp(void)
{
  unsigned short cputemp_flag = TRUE;
  start = TRUE;
  
  return cputemp_flag;
} //END switch_cputemp


// #################################################################################################################


void save_custom_Variables(short CPU_WarningTemp) 
{  
  char CPUWarnTempSave[5], custom_Variables_path[100];;
  FILE *save_Variables_file;
     
  strcpy(custom_Variables_path, homedir);
  strcat(custom_Variables_path, "/shit.save");
 
 //opening the file
  save_Variables_file=fopen(custom_Variables_path, "w+");
  
  
//---CPUWARNTEMP----

 //saving the CPU Warning Temperature in the Sysinfo-Settingfile
  fputs("CPU Warning Temp in degree C: ", save_Variables_file );
  
 //converting int to string
  sprintf(CPUWarnTempSave, "%d", CPU_WarningTemp); 
 
  fputs(CPUWarnTempSave, save_Variables_file);
  fputs("\n", save_Variables_file);
    
//--END CPUWARNTEMP---- 
  

  
 //closing the setting-file   
  fclose(save_Variables_file);   
}// save_custom_Variables


// #################################################################################################################


short switch_setWarnTemp(void)
{
  short CPU_WarningTemp = CPU_WARNINGTEMP;

  printf("Please enter new CPU Warning Temperature in C: ");
  scanf("%3hi", &CPU_WarningTemp);
  
  if(0 > CPU_WarningTemp)
    CPU_WarningTemp = CPU_WarningTemp * (-1);
    
  printf("CPU Warning Temperature Set! (%d C)\n", CPU_WarningTemp);
  start = TRUE;
  sleep(2);
  // Saving the custom CPU Warning Temperature
  save_custom_Variables(CPU_WarningTemp);
  
  return CPU_WarningTemp;
}// END switch_setWarnTemp

 
 unsigned short switch_disk_free(void)
{
  unsigned short disk_flag = TRUE;
  start = TRUE;
  
  return disk_flag;
} //END switch_disk_free


unsigned short switch_ppp(void)
{
  unsigned short ppp_flag = TRUE;
  
  start = TRUE;
  return ppp_flag;
}//END switch_ppp

unsigned short switch_clear_ppp(void)
{
  unsigned short ppp_clear_flag = TRUE;
  
  start = TRUE;
  return ppp_clear_flag;
  
}

unsigned short switch_cpu_load_verbose(void)
{
  unsigned short cpu_load_verbose = TRUE;
  start = TRUE;
  return cpu_load_verbose;
}

unsigned short switch_mem_verbose(void)
{
  unsigned short mem_verbose = TRUE;
  start = TRUE;
  return mem_verbose = TRUE;
}

unsigned short switch_swap(void)
{
  unsigned short swap_flag = TRUE;
  start = TRUE;
  return swap_flag = TRUE;
}

unsigned short switch_swap_verbose(void)
{
  unsigned short swap_verbose = TRUE;
  start = TRUE;
  return swap_verbose = TRUE;
}

unsigned short switch_net_verbose(void)
{
  unsigned short net_verbose = TRUE;
  start = TRUE;
  return net_verbose = TRUE;
}

//***************************************************check dir/file**************************************************************

int exist_directory(const char *Path)
{
  struct stat StatBuf;

  if(stat(Path,&StatBuf)==0)
  {
    switch(StatBuf.st_mode & S_IFMT)
    {
      case S_IFDIR: return(TRUE);
      case S_IFREG:
      case S_IFLNK:
        default: return(FALSE);
    }
  }
  return(FALSE);
}


void get_homedir(void)
{
  struct passwd *pw = NULL;

  if((pw = getpwuid(getuid())) == NULL)
  {
    
    if((homedir = getenv("HOME")) == NULL)
    {
      printf("Unable to get home directory, set it to /tmp.\n");
      homedir = strdup("/tmp");
    }
  }
  else
  {
    
    if(pw) 
      homedir = strdup(pw->pw_dir);
  }

  //return homedir;
}

//====================================================== sysfunctions========================================================

void head(void)
{
  struct tm *tmnow;
  time_t tnow;

  time(&tnow);
  tmnow = localtime(&tnow);  
  printw("\n%02d.%02d.%04d                   [ShIT %s]                      %02d:%02d \n", tmnow -> tm_mday,
         tmnow -> tm_mon + 1,
         tmnow -> tm_year + 1900,
         PRGVERSION,
         tmnow -> tm_hour,
         tmnow -> tm_min);
  printw("======================================================================\n\n");
} //END head


// #################################################################################################################


short get_custom_Variables(unsigned short cputemp_flag)
{
  //Enter number of settings to get
  //int SettingsToGet = 1;  
  unsigned char custom_Variables_path[100], GetCPUWarnTemp[40];
  unsigned short i = 1;
  short end = 0;
  short CPU_WarningTemp = 0;
  char *ptr_char, trash[35];
  
  FILE*get_Variables_file;
  
  strcpy(custom_Variables_path, homedir);
  strcat(custom_Variables_path, "/shit.save");
  get_Variables_file=fopen(custom_Variables_path, "r");
  
  if(NULL != get_Variables_file)
  {
    while(0 == end)
    {
      fgets(GetCPUWarnTemp, 35, get_Variables_file );
      if(TRUE == cputemp_flag)
      {
        i = 1;
        i = strncmp("CPU Warning Temp in degree C:",GetCPUWarnTemp, 29);
        if(0 == i)
        {
          ptr_char = strtok(GetCPUWarnTemp,":");
          strcpy(trash, ptr_char);
          ptr_char = strtok(NULL,":");
          strcpy(GetCPUWarnTemp, ptr_char);
          sscanf(GetCPUWarnTemp, "%hi\n", &CPU_WarningTemp);
        }
      }
      GetCPUWarnTemp[0] = '\0';
      end = feof(get_Variables_file);
    }                         
    return CPU_WarningTemp;
    fclose(get_Variables_file);
  }
  else 
  {
    
    printf("\nNo config-file found or config-file corrupt!\n\nPlease start shit with -st option to create a new config file.\n\n");
  /*printw("No config-file found or config-file corrupt!\t\t\t\t\t\t\t[WARNING]\n* Please type \"sysinfo_config\" \
    to create a new config-file\n\n");*/
    
  //end program if no config-file was found
    exit(0);
  }
}


// #################################################################################################################


void uptime(void)
{
  unsigned int uptime_unsorted = 0;
  unsigned char c;
  unsigned int DD;
  unsigned int HH;
  unsigned int MM;
//   unsigned int SS; //uptime seconds
  FILE *uptime_file;  

  uptime_file=fopen("/proc/uptime","r");

  if(NULL != uptime_file)
  {  
    while((c=fgetc(uptime_file))!= '.')
    {
      unsigned int i;
      i = atoi(&c);
      //uptime unsorted == uptime in seconds
      uptime_unsorted = (uptime_unsorted * 10) + i;
    }
    
//     SS = uptime_unsorted % 60; 
    MM = uptime_unsorted / 60 % 60;
    HH = uptime_unsorted / 60 / 60 % 24;
    DD = uptime_unsorted / (60 * 60 * 24);

    fclose(uptime_file);
    if(0 != DD)
      printw("Uptime:\t\t%id %02ih %02im\n",DD,HH,MM);
    else
    {  
      if(0 != HH)
        printw("Uptime:\t\t%ih %02im\n",HH,MM);
      else
        printw("Uptime:\t\t%im\n",MM);
    }
  }
  else
  {
    printw("Open file \"proc/uptime\" failed!\n");
  }

} //end UPTIME


// #################################################################################################################


unsigned short kernel_v(void)
{
  static char *Linux_v;
  unsigned short old_kernel = FALSE;
  
  struct utsname uname_s;
  
  uname(&uname_s);
  
  if(TRUE == first_run)
  {
    Linux_v = strdup(uname_s.release);
    printw("Linux:\t\t%s\n",Linux_v); 
    
    if(strstr(Linux_v, "2.6") == NULL )
      old_kernel = TRUE;
  }//END IF first_run true
  else
  {
    printw("Linux:\t\t%s\n",Linux_v);
    
    if(strstr(Linux_v, "2.6") == NULL )
      old_kernel = TRUE;
  }
  return old_kernel;
} //END detect Kernel version and output


// #################################################################################################################

void memory_state(int *pos_memtotal, int *pos_memfree, struct flagfield *flags_ptr)
{
  char mem_str[20], trash[10];
  int pos, end = 0;
  unsigned long long mem_size;
  FILE *mem_file;
  
  errno = 0;
  mem_file=fopen("/proc/meminfo","r");
  
  if(NULL != mem_file)
  {
    if(flags_ptr->old_kernel == TRUE)      // in kernel < 2.6 the file /proc/memory contains 2 headlines
    {                           //wich are not needfull
      unsigned char trash[100];
      unsigned int i;
      for(i=2; i>=0 ; i--)
        fgets(trash, 100, mem_file);
    }
    
    while(0 == end)
    {
      pos = ftell(mem_file);
      fscanf(mem_file,"%15s%10lld%5s\n",mem_str ,&mem_size ,trash);
      
      if(0 == strcmp(mem_str, "MemTotal:"))
      {
        *pos_memtotal = pos;
        
        if(ULONG_MAX < mem_size)    //memory > 4GB
          flags_ptr->high_mem_flag = TRUE;
      }

      if(! strcmp(mem_str, "MemFree:"))
        *pos_memfree = pos;

      end = feof(mem_file);
    }
    fclose(mem_file);
  }
  else
  {
    printf("/proc/meminfo: %s\n", strerror(errno));
    errno = 0;
  }
    
  return;
}

void memory(struct flagfield *flags_ptr, int *pos_memtotal, int *pos_memfree)
{
  char mem_str[20], trash[10];
  FILE *mem_file;
  
  errno = 0;
  mem_file=fopen("/proc/meminfo","r");
  
  if(NULL != mem_file)
  {
    if(TRUE == flags_ptr->high_mem_flag)
    {
      unsigned long long *mem_size;
      
      mem_size =(unsigned long long *)malloc(2 * sizeof(*mem_size));
      if(NULL == mem_size)
        printf("No memory available");
    
      fseek(mem_file,  *pos_memtotal, SEEK_SET);
      fscanf(mem_file,"%15s%20lld%5s\n",mem_str ,&mem_size[0] ,trash);
      
      fseek(mem_file,  *pos_memfree, SEEK_SET);
      fscanf(mem_file,"%15s%20lld%5s\n",mem_str ,&mem_size[1] ,trash);
      
      int mem = 100 - ((float)mem_size[1] / (float)mem_size[0]) * 100;
      
      if(FALSE == flags_ptr->mem_verbose)
      {
        printw("MemUse:\t\t[");
      
        int i = 0;
        for(;i < 20; i++)
          printw(mem /5 > i ? "#" : " ");
      
        printw("] %d%%\n",mem);  
      }
      else
      {
        printw("MemUse:\t\t%lld KB / %lld KB\n",(mem_size[0]-mem_size[1]) ,mem_size[0]);
        printw("\t\t[");
      
        int i = 0;
        for(;i < 20; i++)
          printw(mem /5 > i ? "#" : " ");
      
        printw("] %d%%\n",mem);
      }
      if(NULL != mem_size)
        free(mem_size);
    }
    else
    {
      unsigned long *mem_size;
      
      mem_size =(unsigned long *)malloc(2 * sizeof(*mem_size));
      if(NULL == mem_size)
        printw("No memory available");
        
      fseek(mem_file,  *pos_memtotal, SEEK_SET);
      fscanf(mem_file,"%15s%10ld%5s\n",mem_str ,&mem_size[0] ,trash);

      fseek(mem_file,  *pos_memfree, SEEK_SET);
      fscanf(mem_file,"%15s%10ld%5s\n",mem_str ,&mem_size[1] ,trash);
      
      int mem = 100 - ((float)mem_size[1] / (float)mem_size[0]) * 100;
      
      if(FALSE == flags_ptr->mem_verbose)
      {
        printw("MemUse:\t\t[");
      
        int i = 0;
        for(;i < 20; i++)
          printw(mem /5 > i ? "#" : " ");
      
        printw("] %d%%\n",mem);  
      }
      else
      {
        printw("MemUse:\t\t%ld KB / %ld KB\n",(mem_size[0]-mem_size[1]) ,mem_size[0]);
        printw("\t\t[");
      
        int i = 0;
        for(;i < 20; i++)
          printw(mem /5 > i ? "#" : " ");
      
        printw("] %d%%\n",mem);
      }
      if(NULL != mem_size)
        free(mem_size);
    }
    fclose(mem_file);
  }
  else
  {
    printw("/proc/meminfo: %s\n", strerror(errno));
    errno = 0;
  }
}//END memory

//#######################################################################

void swap_state(int *pos_swaptotal, int *pos_swapfree, struct flagfield *flags_ptr)
{
  char swap_str[20], trash[10];
  int pos, end = 0;
  unsigned long long swap_size;
  FILE *swap_file;
  
  errno=0;
  swap_file=fopen("/proc/meminfo","r");
  
  if(NULL != swap_file)
  {
    if(flags_ptr->old_kernel == TRUE)
    {
      unsigned char trash[100];
      unsigned int i;
      for(i=3; i>0 ; i--)
        fgets(trash, 100, swap_file);
    }
    
    while(0 == end)
    {
      pos = ftell(swap_file);
      fscanf(swap_file,"%15s%10lld%5s\n",swap_str ,&swap_size ,trash);
      
      if(0 == strcmp(swap_str, "SwapTotal:"))
      {
        *pos_swaptotal = pos;
        
        if(ULONG_MAX < swap_size)
          flags_ptr->high_swap_flag = TRUE;
      }

      if(! strcmp(swap_str, "SwapFree:"))
        *pos_swapfree = pos;

      end = feof(swap_file);
    }
    fclose(swap_file);
  }
  else
  {
    printf("/proc/meminfo: %s\n", strerror(errno));
    errno = 0;
  }
  
  return;
}//END swap_state

void swap(struct flagfield *flags_ptr, int *pos_swaptotal, int *pos_swapfree)
{
  char swap_str[20], trash[10];
  FILE *swap_file;
  
  errno=0;  
  swap_file=fopen("/proc/meminfo","r");
  
  if(NULL != swap_file)
  {
    if(TRUE == flags_ptr->high_swap_flag)
    {
      unsigned long long *swap_size;
      
      swap_size =(unsigned long long *)malloc(2 * sizeof(*swap_size));
      if(NULL == swap_size)
        printf("No memory available");
    
      fseek(swap_file,  *pos_swaptotal, SEEK_SET);
      fscanf(swap_file,"%15s%20lld%5s\n",swap_str ,&swap_size[0] ,trash);
      
      fseek(swap_file,  *pos_swapfree, SEEK_SET);
      fscanf(swap_file,"%15s%20lld%5s\n",swap_str ,&swap_size[1] ,trash);
      
      int swap = 100 - ((float)swap_size[1] / (float)swap_size[0]) * 100;
      
      if(FALSE == flags_ptr->swap_verbose)
      {
        printf("SwapUse:\t[");
      
        int i = 0;
        for(;i < 20; i++)
          printf(swap /5 > i ? "#" : " ");
      
        printf("] %d%%\n",swap);  
      }
      else
      {
        printf("SwapUse:\t%lld KB / %lld KB\n",(swap_size[0]-swap_size[1]) ,swap_size[0]);
        printf("\t\t[");
      
        int i = 0;
        for(;i < 20; i++)
          printf(swap /5 > i ? "#" : " ");
      
        printf("] %d%%\n",swap);
      }
      if(NULL != swap_size)
        free(swap_size);
    }
    else
    {
      unsigned long *swap_size;
      
      swap_size =(unsigned long *)malloc(2 * sizeof(*swap_size));
      if(NULL == swap_size)
        printf("No memory available");
        
      fseek(swap_file,  *pos_swaptotal, SEEK_SET);
      fscanf(swap_file,"%15s%10ld%5s\n",swap_str ,&swap_size[0] ,trash);

      fseek(swap_file,  *pos_swapfree, SEEK_SET);
      fscanf(swap_file,"%15s%10ld%5s\n",swap_str ,&swap_size[1] ,trash);
      
      int swap = 100 - ((float)swap_size[1] / (float)swap_size[0]) * 100;
      
      if(FALSE == flags_ptr->swap_verbose)
      {
        printw("SwapUse:\t[");
      
        int i = 0;
        for(;i < 20; i++)
          printw(swap /5 > i ? "#" : " ");
      
        printw("] %d%%\n",swap);  
      }
      else
      {
        printw("SwapUse:\t%ld KB / %ld KB\n",(swap_size[0]-swap_size[1]) ,swap_size[0]);
        printw("\t\t[");
      
        int i = 0;
        for(;i < 20; i++)
          printw(swap /5 > i ? "#" : " ");
      
        printw("] %d%%\n",swap);
      }
      if(NULL != swap_size)
        free(swap_size);
    }
    fclose(swap_file);
  }
  else
  {
    printw("/proc/meminfo: %s\n", strerror(errno));
    errno=0;
  }
}//END swap

// #################################################################################################################


void cputemp(short CPU_WarningTemp)
{ 
  char cputemp_string[35];
  char num[] ="0123456789";
  char cputemp_char;
  unsigned int temp = 0;
  unsigned int tempbegin;
  unsigned int tempend;
  int cputemp = 0;
  char path[45];
  static unsigned short temp_device_flag;
  
  FILE *cputemp_file;
  
  if(1 > temp_device_flag)
  {
    cputemp_file=fopen("/sys/bus/i2c/devices/1-002d/temp1_input", "r");
    if(NULL != cputemp_file)
    {
      temp_device_flag = 1;
      fclose(cputemp_file);
    }
  
    cputemp_file=fopen("/proc/acpi/thermal_zone/ATF0/temperature", "r");
    if(NULL != cputemp_file)
    {
      temp_device_flag = 2;
      fclose(cputemp_file);
    }
  
    cputemp_file=fopen("/proc/acpi/thermal_zone/THRM/temperature","r");
    if(NULL != cputemp_file)
    {
      temp_device_flag =3;
      fclose(cputemp_file);
    }
  }//END if  
  switch (temp_device_flag)
  {
    case 3: strncpy (path,"/proc/acpi/thermal_zone/THRM/temperature",sizeof(path));
    break;
    case 2: strncpy(path, "/proc/acpi/thermal_zone/ATF0/temperature", sizeof(path));
    break;
    case 1: break;
    default: printw("CPU-Temp:\tNo sensors found!\n");   
     
  }
  
  if(1 < temp_device_flag)
  {
    cputemp_file=fopen(path, "r");
    fgets(cputemp_string, 35, cputemp_file);
    
    tempbegin = strcspn(cputemp_string, num);
    tempend = strcspn(cputemp_string, "C");
    
    int i = tempbegin;
    for (; i < (tempend-1); i++)
    {
      cputemp_char = cputemp_string[i];     
      temp = (((int)cputemp_char)- 48);        //silly but working "ASCII2int"
      cputemp = (cputemp * 10) + temp;
    }
    
    if (cputemp < CPU_WarningTemp)
    {   
      printw("CPU-Temp:\t%d C\n",cputemp);
    }  
    else  
    {
      printw("CRITICAL CPU TEMPERATURE !!! (%d C)\n", cputemp);
    }
    
    fclose(cputemp_file);
     
  }
  else
    if(1 == temp_device_flag)
  {
    cputemp_file=fopen("/sys/bus/i2c/devices/1-002d/temp1_input", "r");
    fgets(cputemp_string, 7, cputemp_file);
    int i = 0;
    for( ;i < 5; i++)
    {
      cputemp_char = cputemp_string[i];
      temp = (((int)cputemp_char)- 48);
      cputemp = (cputemp * 10) + temp;
    }
    cputemp /= 1000;
    if (cputemp < CPU_WarningTemp)
    {   
      printw("CPU-Temp:\t%d C\n",cputemp);
    }  
    else  
    {
      attrset(A_BLINK|A_BOLD);
      printw("CRITICAL CPU TEMPERATURE !!! (%d C)\n", cputemp);
      attrset(0);
    }
      
    fclose(cputemp_file);
  }

} //END cputemp


// #################################################################################################################
 

void cpumodel(struct flagfield *flags_ptr)
{
  static unsigned char cpumodel_save[50];
  
  FILE *cpumodel_file;
  
  if (flags_ptr->cpumodel_check == TRUE) // already ascertained the model?
  {
    char cpumodel[50], cpuinfo[50], trash[100];
    int cpubegin;
    
    errno=0;
    cpumodel_file=fopen("/proc/cpuinfo", "r");
  
    if(NULL != cpumodel_file)
    {
      int i;
      for (i = 4; i > 0; i--)
        fgets(trash, 100, cpumodel_file);
    
      
      fgets(cpuinfo, 50, cpumodel_file);
      fclose(cpumodel_file);
  
      //Allocating the first CPU-Model Character
      cpubegin = strcspn( cpuinfo, ":") + 2;
      
  
      i = cpubegin; 
      for (; cpubegin < 50; cpubegin ++)
        cpumodel[cpubegin - i] = cpuinfo[cpubegin];

    
      //Display the CPU-Model
      printw("CPU-Model:\t%s", cpumodel);
    }
    else
    {
      printw("/proc/cpuinfo: %s\n", strerror(errno));
      errno=0;
    }
    
    flags_ptr->cpumodel_check = FALSE;
    strcpy(cpumodel_save , cpumodel); 
  }
  
  else
    printw("CPU-Model:\t%s", cpumodel_save); //Printing CPU - Model from Memory
    
}// END cpumodel


// #################################################################################################################


void cpu_load(struct flagfield *flags_ptr)
{
  FILE *cpu_load_file;
  unsigned int user_new=0, nice_new=0, system_new=0, idle_new=0, wa_new=0, hi_new=0, si_new=0;
  unsigned int user=0, nice=0, system=0, idle=0;
  unsigned int wa=0, hi=0, si = 0;
  static unsigned int user_old=0, nice_old=0, system_old=0, idle_old=0;
  static unsigned int wa_old=0, hi_old=0, si_old=0;
  char cpu[6];
  
  errno=0;
  cpu_load_file=fopen("/proc/stat","r");
  
  if(NULL != cpu_load_file)
  {
    if(FALSE == flags_ptr->old_kernel)
      fscanf(cpu_load_file,"%s%d%d%d%d%d%d%d\n",cpu,&user_new,&nice_new,&system_new,&idle_new,&wa_new,&hi_new,&si_new);
    else
      fscanf(cpu_load_file,"%s%d%d%d%d\n",cpu,&user_new,&nice_new,&system_new,&idle_new);

    //printf("debug1\n");
    if(TRUE == flags_ptr->cpu_load_verbose)
    {
      user = user_new - user_old;
      nice = nice_new - nice_old;
      system = system_new - system_old;
      idle = idle_new - idle_old;
      if(FALSE == flags_ptr->old_kernel)
      {
        wa = wa_new - wa_old;
        hi = hi_new - hi_old;
        si = si_new - si_old;
      }
    
      if(1 < updatetime)
      {
        user /= updatetime;
        nice /= updatetime;
        system /= updatetime;
        idle /= updatetime;
        
        if(FALSE == flags_ptr->old_kernel)
        {
          wa /= updatetime;
          hi /= updatetime;
          si /= updatetime;
        }
      }
      
      if(FALSE == flags_ptr->old_kernel)
      {
        if(TRUE == first_run || 150 <= user)
          printw("CPU-Load:\tuser:\t0%%\n\t\tsys:\t0%%\n\t\tnice:\t0%%\n\t\tidle:\t0%%\n\t\twa:\t0%%\n\t\thi:\t0%%\n\t\tsi:\t0%% \n");
        else
          printw("CPU-Load:\tuser:\t%d%%\n\t\tsys:\t%d%%\n\t\tnice:\t%d%%\n\t\tidle:\t%d%%\n\t\twa:\t%d%%\n\t\thi:\t%d%%\n\t\tsi:\t%d%% \n",user,system, nice, idle, wa, hi, si);
      }
      else
      {
        if(TRUE == first_run)
          printw("CPU-Load:\tuser:\t0%%\n\t\tsys:\t0%%\n\t\tnice:\t0%%\n\t\tidle:\t0%%\n");
    
        if(0 != user_old)
          printw("CPU-Load:\tuser:\t%d%%\n\t\tsys:\t%d%%\n\t\tnice:\t%d%%\n\t\tidle:\t%d%%\n",user,system, nice, idle);
      }
    
      user_old = user_new;
      nice_old = nice_new;
      system_old = system_new;
      idle_old = idle_new;
      
      if(FALSE == flags_ptr->old_kernel)
      {
        wa_old = wa_new;
        hi_old = hi_new;
        si_old = si_new;
      }
    }
    else
    {
      idle = idle_new - idle_old;
    
      if(1 < updatetime)
      {
        idle /= updatetime;
      }
    
      if(TRUE == first_run)
        printw("CPU-Load:\t[                    ] 0%%\n");
      else
      {
        printw("CPU-Load:\t[");
        int i = 0;
        for(;i < 20; i++)
          if ((100 - idle)/5 > i && idle <= 100)
            printw("#");
        else
          printw(" ");
       
        if(101 > idle)
          printw("] %d%%\n",(100-idle));
        else
          printw("] 0%%\n");
      }
      idle_old = idle_new;
    }
    fclose(cpu_load_file);
  }
  else
  {
    printw("/proc/stat: %s\n", strerror(errno));
    errno=0;
  }
}


// #################################################################################################################

void chk_ShITDir(void)
{  
  unsigned short homedir_flag;
  homedir_flag = exist_directory(homedir);
  if (FALSE == homedir_flag)
  {
    //Creating new Sysinfo Directory
    if(mkdir(homedir MODUS) == -1) /*not so beautifull but more portable*/
    {
      printf("%s: Could not creat file\n",homedir);
      exit(0);
    }
  }
}

// ##################################################################################################################

void disk_free(void)    //this funktion is bad and will be replaced later
{
  FILE *df_file;
  char df_tmp[254]= "";
  char df_path[200];
  short eof_flag = 0;
  system("df -hl > ~/.shit/df");
  strcpy(df_path, homedir);
  strcat(df_path, "/df");
  
  errno=0;
  df_file = fopen(df_path,"r");
  if(NULL != df_file)
  {
    while(0 == eof_flag)
    {
      printw("%s",df_tmp);
      fgets(df_tmp, 250, df_file);
      eof_flag = feof(df_file);
    }
    fclose(df_file);
  }
  else
  {
    printw("%s: %s\n",df_path ,strerror(errno));
    errno=0;
  }
}

// ###################################################################################################################

void net_state(struct flagfield *flags_ptr)
{
  int net_num = 0;
  errno = 0;
  
  FILE *net_file;
    
  net_file = fopen(NET_PATH, "r");
  
  if(NULL != net_file)
  { 
    int i, end=0;
    char trash[200], net[200];
//DEBUG
  //printw("test2\n");
    for(i=0; i<2; i++)              //redas hedline and do it in trash
      fgets(trash, 200, net_file);
        
    while(0 == end)
    {  
      fgets(net, 200, net_file);    
      i = strncmp("  eth",net, 4);    //
//DEBUG
  //printw("test3\n");
      if(0==i)
      {
//DEBUG
  //printw("test4\n");
        flags_ptr->net_exist = TRUE;
        net_num++;
        i=1;
      }
      
      net[0] = '\0';
      end = feof(net_file);
    }
//DEBUG
  //printw("test4\n");
    fclose(net_file);
    if(0 < net_num)
    {
      net_ptr_rx_old=(unsigned int *)malloc(net_num * sizeof(*net_ptr_rx_old));
      if(NULL == net_ptr_rx_old)
        printw("No memory available");
      
      net_ptr_tx_old=(unsigned int *)malloc(net_num * sizeof(*net_ptr_tx_old));
      if(NULL == net_ptr_tx_old)
        printw("No memory available");
      
      net_ptr_rx=(float *)malloc(net_num * sizeof(*net_ptr_rx));
      if(NULL == net_ptr_rx)
        printw("No memory available");
      
      net_ptr_tx=(float *)malloc(net_num * sizeof(*net_ptr_tx));
      if(NULL == net_ptr_tx)
        printw("No memory available");
      
      net_ptr_volume_down=(unsigned long long *)malloc(net_num * sizeof(*net_ptr_volume_down));
      if(NULL == net_ptr_volume_down)
        printw("No memory available");
      
      net_ptr_volume_up=(unsigned long long *)malloc(net_num * sizeof(*net_ptr_volume_up));
      if(NULL == net_ptr_volume_up)
        printw("No memory available");
      
      net_ptr_rx_first=(unsigned int *)malloc(net_num * sizeof(*net_ptr_rx_first));
      if(NULL == net_ptr_rx_first)
        printw("No memory available");
      
      net_ptr_tx_first=(unsigned int *)malloc(net_num * sizeof(*net_ptr_tx_first));
      if(NULL == net_ptr_tx_first)
        printw("No memory available");
      
      net_ptr_total_rx_volume=(unsigned long long *)malloc(net_num * sizeof(*net_ptr_total_rx_volume));
      if(NULL == net_ptr_total_rx_volume)
        printw("No memory available");
        
      net_ptr_total_tx_volume=(unsigned long long *)malloc(net_num * sizeof(*net_ptr_total_tx_volume));
      if(NULL == net_ptr_total_tx_volume)
        printw("No memory available");
    }
    else
    {
      flags_ptr->net_exist = FALSE;
      return;
    }
//DEBUG
  //printw("test5\n");
    net_num_max = net_num - 1;
  }
  else
  {
    printf("%s: %s\n", NET_PATH, strerror(errno));
    errno=0;
    flags_ptr->net_exist = FALSE;
    exit(0);
  }
  flags_ptr->net_exist = TRUE;
  return;
}//END net_state

void net(struct flagfield *flags_ptr)
{
  char net[200], dev[10]={0}, *ptr_char;
  int end=0;
  unsigned int i, trash_int, net_num=0;
  
  FILE *net_file;
    
  net_file = fopen(NET_PATH,"r");
  
  if(NULL != net_file)
  {
    while(0 == end)
    {
      fgets(net, 200, net_file);
      i = 1;
      i = strncmp("  eth",net, 4);
      if(0 == i)
      {
        ptr_char = strtok(net,":");
        strcpy(dev, ptr_char);
        ptr_char = strtok(NULL,":");
        strcpy(net, ptr_char);
        sscanf(net, "%u%d%d%d%d%d%d%d%u",&net_rx_new,&trash_int,&trash_int,&trash_int, &trash_int\
            ,&trash_int,&trash_int,&trash_int,&net_tx_new);
        if(FALSE == first_run)
        {
          if(net_rx_new < net_ptr_rx_old[net_num])
            net_ptr_rx[net_num] = UINT_MAX - net_ptr_rx_old[net_num] + net_rx_new;
          else
            net_ptr_rx[net_num] = net_rx_new - net_ptr_rx_old[net_num];
           
          if(net_tx_new < net_ptr_tx_old[net_num])
            net_ptr_tx[net_num] = UINT_MAX - net_ptr_tx_old[net_num] + net_tx_new;
          else
            net_ptr_tx[net_num] = net_tx_new - net_ptr_tx_old[net_num];
           
          if(1 < updatetime);
          {
            net_ptr_rx[net_num] /= updatetime;
            net_ptr_tx[net_num] /= updatetime;
          }
        }

        if(TRUE == first_run)
        {
          net_ptr_total_rx_volume[net_num] = net_rx_new;
          net_ptr_total_tx_volume[net_num] = net_tx_new;
        }
     
        net_ptr_rx_old[net_num] = net_rx_new;
        net_ptr_tx_old[net_num] = net_tx_new;
        
        //calculate volume (new-volume - old-volume + volume-from-file)
        net_ptr_total_rx_volume[net_num] = net_ptr_total_rx_volume[net_num] + net_ptr_rx[net_num];
        net_ptr_total_tx_volume[net_num] = net_ptr_total_tx_volume[net_num] + net_ptr_tx[net_num];
        net_num++;
      }
    
      net[0] = '\0';
      end = feof(net_file);
    }
    fclose(net_file);
  }
  else
  {
    printw("Open file \"%s\" failed!\n", NET_PATH);
  }
  
  if(net_num_max > 254)
    printw("no \"net\" in \"%s\" found!", NET_PATH);
  else
  {
    for(i=0;i <= net_num_max; i++)
    {
      char unit_rx[5]="  B", unit_tx[5]="  B", unit_rx_volume[5]="  B", unit_tx_volume[5]="  B", unit_total_volume[5]="  B";
      unsigned long long net_rx_volume_display, net_tx_volume_display,net_total_volume_display;
        
      net_rx_volume_display = net_ptr_total_rx_volume[i];
      net_tx_volume_display = net_ptr_total_tx_volume[i];
        
      if(1024 < net_ptr_rx[i])
      {
        strcpy(unit_rx,"KiB");
        net_ptr_rx[i] /= 1024.0;
      
        if(1024 < net_ptr_rx[i])
        {
          strcpy(unit_rx,"MiB");
          net_ptr_rx[i] /= 1024.0;
          if(1024 < net_ptr_rx[i])
          {
            strcpy(unit_rx,"GiB");
            net_ptr_rx[i] /= 1024.0;
          }
        }
      }
      
      if(1024 < net_ptr_tx[i])
      {
        strcpy(unit_tx,"KiB");
        net_ptr_tx[i] /= 1024.0;
      
        if(1024 < net_ptr_tx[i])
        {
          strcpy(unit_tx,"MiB");
          net_ptr_tx[i] /= 1024.0;
          if(1024 < net_ptr_tx[i])
          {
            strcpy(unit_tx,"GiB");
            net_ptr_tx[i] /= 1024.0;
          }
        }
      }
      
      if(1024 < net_rx_volume_display)
      {
        strcpy(unit_rx_volume,"KiB");
        net_rx_volume_display /= 1024;
      
        if(1024 < net_rx_volume_display)
        {
          strcpy(unit_rx_volume,"MiB");
          net_rx_volume_display /= 1024;
	        
          if(1024 < net_rx_volume_display)
          {
            strcpy(unit_tx_volume,"GiB");
            net_rx_volume_display /= 1024;
          }
        }
      }
      
      if(1024 < net_tx_volume_display)
      {
        strcpy(unit_tx_volume,"KiB");
        net_tx_volume_display /= 1024;
      
        if(1024 < net_tx_volume_display)
        {
          strcpy(unit_tx_volume,"MiB");
          net_tx_volume_display /= 1024;
          if(1024 < net_tx_volume_display)
          {
            strcpy(unit_tx_volume,"GiB");
            net_tx_volume_display /= 1024;
          }
        }
      }

      if(TRUE == flags_ptr->net_verbose) //verbose
      {
        if(TRUE == first_run)
          printw("eth%i:\t\tRX:   0.0   B/s\tdown: %5lld %s\n\t\tTX:   0.0   B/s\tup:   %5lld %s\n",i ,net_rx_volume_display, unit_rx_volume, net_tx_volume_display, unit_tx_volume);
        else
          printw("eth%i:\t\tRX:%6.1f %s/s\tdown: %5lld %s\n\t\tTX:%6.1f %s/s\tup:   %5lld %s\n",i ,net_ptr_rx[i] ,unit_rx ,net_rx_volume_display ,unit_rx_volume ,net_ptr_tx[i] ,unit_tx ,net_tx_volume_display ,unit_tx_volume);
      
      //printw("\t\tdown:\t%lld %s\n\t\tup:\t%lld %s\n",net_rx_volume_display, unit_rx_volume, net_tx_volume_display, unit_tx_volume);
        
        net_total_volume_display = (net_ptr_total_rx_volume[i] + net_ptr_total_tx_volume[i]);
      
        if(1024 < net_total_volume_display)
        {
          strcpy(unit_total_volume,"KiB");
          net_total_volume_display /= 1024;
        
          if(1024 < net_total_volume_display)
          {
            strcpy(unit_total_volume,"MiB");
            net_total_volume_display /= 1024;
          
            if(1024 < net_total_volume_display)
            {
              strcpy(unit_total_volume,"GiB");
              net_total_volume_display /= 1024;
            }
          }
        }
       
        printw("\t\t\t\ttotal:%5lld %s\n",net_total_volume_display, unit_total_volume);
      }
      else  //non-verbose
      {
        if(TRUE == first_run)
          printw("eth%i:\t\tRX:   0.0 B/s\n\t\tTX:   0.0 B/s\n",i);
        else
          printw("eth%i:\t\tRX:%6.1f %s/s\n\t\tTX:%6.1f %s/s\n",i ,net_ptr_rx[i] ,unit_rx ,net_ptr_tx[i] ,unit_tx);
      }
    }//END for() to write every interface
  }
}


void ppp(void)
{
  char ppp[200], dev[10]={0}, *ptr_char, ppp_volume_path[100];
  int end=0;
  unsigned int i, trash_int, ppp_num=0;
  
  FILE *ppp_file, *ppp_volume_file;
  
  strcpy(ppp_volume_path, homedir);
  strcat(ppp_volume_path, "/ppp_volume");
  
  ppp_file = fopen(NET_PATH, "r");
  
  if(NULL != ppp_file)
  {
    while(0 == end)
    {
      fgets(ppp, 200, ppp_file);
      i = 1;
      i = strncmp("  ppp",ppp, 4);
      if(0 == i)
      {
        ptr_char = strtok(ppp,":");
        strcpy(dev, ptr_char);
        ptr_char = strtok(NULL,":");
        strcpy(ppp, ptr_char);
        sscanf(ppp, "%10u%10i%10i%10i%10i%10i%10i%10i%10u",&ppp_rx_new,&trash_int,&trash_int,&trash_int, &trash_int\
            ,&trash_int,&trash_int,&trash_int,&ppp_tx_new);
         
        if(FALSE == first_run)
        {
          ppp_ptr_rx[ppp_num] = ppp_rx_new - ppp_ptr_rx_old[ppp_num];
          ppp_ptr_tx[ppp_num] = ppp_tx_new - ppp_ptr_tx_old[ppp_num];
          if(1 < updatetime);
          {
            ppp_ptr_rx[ppp_num] /= updatetime;
            ppp_ptr_rx[ppp_num] /= updatetime;
          }
        }
        if(TRUE == first_run)
        {
          ppp_ptr_rx_first[ppp_num] = ppp_rx_new;
          ppp_ptr_tx_first[ppp_num] = ppp_tx_new;
        }
        
        ppp_ptr_rx_old[ppp_num] = ppp_rx_new;
        ppp_ptr_tx_old[ppp_num] = ppp_tx_new;
        
        //calculate volume (new-volume - old-volume + volume-from-file)
        ppp_ptr_total_rx_volume[ppp_num] = ppp_rx_new - ppp_ptr_rx_first[ppp_num] + ppp_ptr_volume_down[ppp_num];
        ppp_ptr_total_tx_volume[ppp_num] = ppp_tx_new - ppp_ptr_tx_first[ppp_num] + ppp_ptr_volume_up[ppp_num];
        ppp_num++;
      }
    
      ppp[0] = '\0';
      end = feof(ppp_file);
    }
    fclose(ppp_file);
  }
  else
  {
    printw("Open file \"%s\" failed!\n", NET_PATH);
  }
  
  if(ppp_num_max > 5)
    printw("no ppp in \"%s\" found!", NET_PATH);
  else
  {
    ppp_volume_file = fopen(ppp_volume_path,"w");   
    if(NULL != ppp_volume_file)
    {
      for(i=0;i <= ppp_num_max; i++)
      {
        char unit_rx[5]="B", unit_tx[5]="B", unit_rx_volume[5]="B", unit_tx_volume[5]="B", unit_total_volume[5]="B";
        unsigned long long ppp_rx_volume_display, ppp_tx_volume_display,ppp_total_volume_display;
        
        ppp_rx_volume_display = ppp_ptr_total_rx_volume[i];
        ppp_tx_volume_display = ppp_ptr_total_tx_volume[i];
        
        if(updatetime > 1)
        {
          ppp_ptr_rx[i] /= updatetime;
          ppp_ptr_tx[i] /= updatetime;
        }
        
        if(1024 < ppp_ptr_rx[i])
        {
          strcpy(unit_rx,"KiB");
          ppp_ptr_rx[i] /= 1024;
        
          if(1024 < ppp_ptr_rx[i])
          {
            strcpy(unit_rx,"MiB");
            ppp_ptr_rx[i] /= 1024;
            if(1024 < ppp_ptr_rx[i])
            {
              strcpy(unit_rx,"GiB");
              ppp_ptr_rx[i] /= 1024;
            }
          }
        }
        
        if(1024 < ppp_ptr_tx[i])
        {
          strcpy(unit_tx,"KiB");
          ppp_ptr_tx[i] /= 1024;
        
          if(1024 < ppp_ptr_tx[i])
          {
            strcpy(unit_tx,"MiB");
            ppp_ptr_tx[i] /= 1024;
            if(1024 < ppp_ptr_tx[i])
            {
              strcpy(unit_tx,"GiB");
              ppp_ptr_tx[i] /= 1024;
            }
          }
        }
        
        if(TRUE == first_run)
          printw("eth%i:\t\tRX:\t0 B/s\n\t\tTX:\t0 B/s\n",i);
        else
          printw("ppp%i:\t\tRX:\t%i %s/s\n\t\tTX:\t%i %s/s\n",i,ppp_ptr_rx[i], unit_rx, ppp_ptr_tx[i], unit_tx);
        
        if(1024 < ppp_rx_volume_display)
        {
          strcpy(unit_rx_volume,"KiB");
          ppp_rx_volume_display /= 1024;
          if(1024 < ppp_rx_volume_display)
          {
            strcpy(unit_rx_volume,"MiB");
            ppp_rx_volume_display /= 1024;
            if(1024 < ppp_rx_volume_display)
            {
              strcpy(unit_rx_volume,"GiB");
              ppp_rx_volume_display /= 1024;
            }
          }
        }
        
        if(1024 < ppp_tx_volume_display)
        {
          strcpy(unit_tx_volume,"KiB");
          ppp_tx_volume_display /= 1024;
          if(1024 < ppp_tx_volume_display)
          {
            strcpy(unit_tx_volume,"MiB");
            ppp_tx_volume_display /= 1024;
            if(1024 < ppp_tx_volume_display)
            {
              strcpy(unit_tx_volume,"GiB");
              ppp_tx_volume_display /= 1024;
            }
          }
        }
        
        printw("\t\tdown:\t%lld %s\n\t\tup:\t%lld %s\n",ppp_rx_volume_display, unit_rx_volume, ppp_tx_volume_display, unit_tx_volume);
        
        ppp_total_volume_display = (ppp_ptr_total_rx_volume[i] + ppp_ptr_total_tx_volume[i]);
        
        if(1024 < ppp_total_volume_display)
        {
          strcpy(unit_total_volume,"KiB");
          ppp_total_volume_display /= 1024;
          if(1024 < ppp_total_volume_display)
          {
            strcpy(unit_total_volume,"MiB");
            ppp_total_volume_display /= 1024;
            if(1024 < ppp_total_volume_display)
            {
              strcpy(unit_total_volume,"GiB");
              ppp_total_volume_display /= 1024;
            }
          }
        }

        printw("\t\ttotal:\t%lld %s\n",ppp_total_volume_display, unit_total_volume);
        
        fprintf(ppp_volume_file,"ppp%i:\n%lld downloaded (Byte)\n%lld uploaded (Byte)\n", i, ppp_ptr_total_rx_volume[i], ppp_ptr_total_tx_volume[i]);
      }

      fclose(ppp_volume_file);
    }
  }
}


void ppp_state(struct flagfield *flags_ptr)
{
  FILE *ppp_file, *ppp_volume_file;
  
  int ppp_num=0;
  
  ppp_file = fopen(NET_PATH, "r");
  if(NULL != ppp_file)
  { 
    int i, end=0;
    char trash[200], ppp[200];
//DEBUG
  //printw("test2\n");
    for(i=0; i<2; i++)              //redas hedline and do it in trash
      fgets(trash, 200, ppp_file);
        
    while(0 == end)
    {  
      fgets(ppp, 200, ppp_file);    
      i = strncmp("  ppp",ppp, 4);    //
//DEBUG
  //printw("test3\n");
      if(0==i)
      {
//DEBUG
  //printw("test4\n");
        flags_ptr->ppp_exist=TRUE;
        ppp_num++;
        i=1;
      }
      
      ppp[0] = '\0';
      end = feof(ppp_file);
    }
//DEBUG
  //printw("test4\n");
    fclose(ppp_file);
    if(0 < ppp_num)
    {
      ppp_ptr_rx_old=(unsigned int *)malloc(ppp_num * sizeof(*ppp_ptr_rx_old));
      if(NULL == ppp_ptr_rx_old)
        printw("No memory available");
      
      ppp_ptr_tx_old=(unsigned int *)malloc(ppp_num * sizeof(*ppp_ptr_tx_old));
      if(NULL == ppp_ptr_tx_old)
        printw("No memory available");
      
      ppp_ptr_rx=(unsigned int *)malloc(ppp_num * sizeof(*ppp_ptr_rx));
      if(NULL == ppp_ptr_rx)
        printw("No memory available");
      
      ppp_ptr_tx=(unsigned int *)malloc(ppp_num * sizeof(*ppp_ptr_tx));
      if(NULL == ppp_ptr_tx)
        printw("No memory available");
      
      ppp_ptr_volume_down=(unsigned long long *)malloc(ppp_num * sizeof(*ppp_ptr_volume_down));
      if(NULL == ppp_ptr_volume_down)
        printw("No memory available");
      
      ppp_ptr_volume_up=(unsigned long long *)malloc(ppp_num * sizeof(*ppp_ptr_volume_up));
      if(NULL == ppp_ptr_volume_up)
        printw("No memory available");
      
      ppp_ptr_rx_first=(unsigned int *)malloc(ppp_num * sizeof(*ppp_ptr_rx_first));
      if(NULL == ppp_ptr_rx_first)
        printw("No memory available");
      
      ppp_ptr_tx_first=(unsigned int *)malloc(ppp_num * sizeof(*ppp_ptr_tx_first));
      if(NULL == ppp_ptr_tx_first)
        printw("No memory available");
      
      ppp_ptr_total_rx_volume=(unsigned long long *)malloc(ppp_num * sizeof(*ppp_ptr_total_rx_volume));
      if(NULL == ppp_ptr_total_rx_volume)
        printw("No memory available");
        
      ppp_ptr_total_tx_volume=(unsigned long long *)malloc(ppp_num * sizeof(*ppp_ptr_total_tx_volume));
      if(NULL == ppp_ptr_total_tx_volume)
        printw("No memory available");
    }
    else
    {
      flags_ptr->ppp_exist = FALSE;
      return;
    }
//DEBUG
  //printw("test5\n");
    ppp_num_max = ppp_num - 1;
    char ppp_volume_path[100];
    strcpy(ppp_volume_path, homedir);
    strcat(ppp_volume_path, "/ppp_volume");
    //ppp_volume_file = fopen(ppp_volume_path,"r");
    ppp_volume_file = fopen(ppp_volume_path,"r");
//DEBUG
  //printw("test6\n");
    if(NULL != ppp_volume_file)
    {
//DEBUG
  //printw("test7\n");
      for(i=0;i <= ppp_num_max; i++)
      {
//DEBUG
  //printw("test7\n");
        char trash_char[20];
        fscanf(ppp_volume_file,"%10s\n",trash_char);
        fscanf(ppp_volume_file,"%lld%10s%10s\n",&ppp_ptr_volume_down[i], trash_char, trash_char);
        fscanf(ppp_volume_file,"%lld%10s%10s\n",&ppp_ptr_volume_up[i],trash_char,trash_char);
        //end = feof(ppp_volume_file);
      }
      fclose(ppp_volume_file);
    }
    else
    {
      FILE *ppp_volume_file;
      strcpy(ppp_volume_path, homedir);
      strcat(ppp_volume_path, "/ppp_volume");
      
      ppp_volume_file = fopen(ppp_volume_path,"w+");
      if(NULL != ppp_volume_file)
      {
        int i;
        for(i=0;i <= ppp_num_max; i++)
        {
          fprintf(ppp_volume_file,"ppp%i:\n0 downloaded (Byte)\n0 uploaded (Byte)\n",i);
          ppp_ptr_volume_down[i] = 0;
          ppp_ptr_volume_up[i] = 0;
        }
        fclose(ppp_volume_file);
      }
    }
  }
  flags_ptr->ppp_exist = TRUE;
  return;
}//END ppp_state

void ppp_clear(void)
{
  FILE *ppp_volume_file;
  char ppp_volume_path[130];
  strcpy(ppp_volume_path, homedir);
  strcat(ppp_volume_path, "/ppp_volume");
  
  ppp_volume_file = fopen(ppp_volume_path,"w+");
  if(NULL != ppp_volume_file)
  {
    int i;
    for(i=0;i <= ppp_num_max; i++)
    {
      fprintf(ppp_volume_file,"ppp%i:\n0 downloaded (Byte)\n0 uploaded (Byte)\n",i);
      ppp_ptr_volume_down[i] = 0;
      ppp_ptr_volume_up[i] = 0;
    }
    fclose(ppp_volume_file);
  }
  else
  {
    printf("could not write to \"%s\"",ppp_volume_path);
  }
}//END ppp_clear


void hostname(void)
{
  char Host_n[256];
  gethostname(Host_n, 255);
  printw("Hostname:\t%s\n",Host_n);
}//end HOSTNAME

/*###################################################################################################################
#================================================MAIN===============================================================#
###################################################################################################################*/

int main(int argc, char **argv)
{
  int pos_memtotal, pos_memfree, pos_swaptotal, pos_swapfree;
  unsigned int old_updatetime = updatetime;
  short CPU_WarningTemp = CPU_WARNINGTEMP;
  
  struct flagfield flags;
  flags.cputemp = FALSE;
  flags.disk = FALSE;
  flags.ppp = FALSE;
  flags.ppp_exist = FALSE;
  flags.ppp_clear = FALSE;
  flags.cpu_load_verbose = FALSE;
  flags.old_kernel= FALSE;
  flags.high_mem_flag = FALSE;
  flags.high_swap_flag = FALSE;
  flags.mem_verbose = FALSE;
  flags.swap_flag = FALSE;
  flags.net_exist = FALSE;
  flags.net_verbose = FALSE;
  flags.cpumodel_check = TRUE;
  
  get_homedir();
  strcat(homedir, "/.shit");

  if (argc > 1) // commited argument?
  {  
    unsigned int i;  
    for (i = argc; i > 1; i--)
    {
      int option_n = i-1;
      int x=27; //number of switches -1
      
      char * const options[]={"--help","-h",\
                              "--foobar","-f",\
                              "--version","-v",\
                              "--updatetime","-u",\
                              "--cputemp","-ct",\
                              "--settemp","-st",\
                              "--diskfree","-df",\
                              "--ppp","-ppp",\
                              "--ppp-clr","-pc",\
                              "--cpu-verbose","-cv",\
                              "--swap",\
                              "--swap-verbose","-sv",\
                              "--mem-verbose","-mv",\
                              "--net-verbose","-nv",\
                              "--about"};

      do
      {
        if((strcmp (argv[option_n],options[x]) == 0)||(0==x))
        {
          switch(x)
          {
            case 27: switch_about();
            break;;
            case 26: 
              case 25: flags.net_verbose = switch_net_verbose();
              break;
            case 24: 
              case 23: flags.mem_verbose = switch_mem_verbose();
              break;
              case 22: flags.swap_verbose = switch_swap_verbose();
            case 21: 
              case 20: flags.swap_flag = switch_swap();
              break;
            case 19: 
              case 18: flags.cpu_load_verbose = switch_cpu_load_verbose();
              break;
            case 17: 
              case 16: flags.ppp_clear = switch_clear_ppp();
            case 15:
              case 14: flags.ppp = switch_ppp();
              break;
            case 13: 
              case 12: flags.disk = switch_disk_free();
              break;
            case 11: 
              case 10: CPU_WarningTemp = switch_setWarnTemp();
              break;
            case 9:
              case 8:  flags.cputemp = switch_cputemp(); 
              break;
            case 7:
              case 6:  switch_updatetime(); 
              break;
            case 5:
              case 4:  switch_version();
              break;
            case 3:
              case 2:  switch_foobar();
              break; 
            case 1:
              default: switch_help(argv[0]);
          }
  
          x=-1; //all options checked (dropout...)

          if((1>=option_n)&&(0==start)) //if last option is read and the prgramm should not start
          {
            exit(0);      //Program exit
          }
          else      
          {
          // empy else because dangling else problem
          }
        }  
        else
        {
          x-=1;
        }
      }
      while(x > -1);
  
    } //END for
  } //END Arguments  
   
//Cheacking for Sysinfo-Directory
  chk_ShITDir();
  CPU_WarningTemp = get_custom_Variables(flags.cputemp); //Loding Setting-File
  
  net_state(&flags);
  memory_state(&pos_memtotal, &pos_memfree, &flags);
  
  if(TRUE == flags.swap_flag)
    swap_state(&pos_swaptotal, &pos_swapfree, &flags);
  
  if(TRUE == flags.ppp)
    ppp_state(&flags);
  
  if(TRUE == flags.ppp_exist)
    if(TRUE == flags.ppp_clear)
      ppp_clear();
    
  initscr();
  noecho();
  
  while(1)
  {
  //drawing the output on screen
    head();
    hostname();
    flags.old_kernel = kernel_v();
    
    uptime();
    
    printw("\n");
    
    cpumodel(&flags);
    cpu_load(&flags);
    
    if(TRUE == flags.cputemp)
      cputemp(CPU_WarningTemp);
    
    printw("\n");
    
    memory(&flags, &pos_memtotal, &pos_memfree);
    
    if(TRUE == flags.swap_flag)
      swap(&flags, &pos_swaptotal, &pos_swapfree);
      
    printw("\n");
    
    net(&flags);
    
    if(TRUE == flags.ppp)
    {
      if(TRUE == flags.ppp_exist)
        ppp();
      else
        printw("no ppp in \"%s\" found!\n", NET_PATH);
    }

    first_run=FALSE;
    
    if(TRUE == flags.disk)
    {
      printw("\n");
      disk_free();
    }
    
    printw("\n");
    refresh();
    updatetime = old_updatetime;
    char c = -1;
    halfdelay(updatetime * 10);
    c=getch();
    if(c >= 0)
      switch(c)
    {
      case 'q': {
        endwin();
        exit(0);
      }
      break;
                  
      case 'h': {
        clear();
        printw("Help for Interactive Commands - ShIT version %s\n",PRGVERSION);
        printw("Current updatetime: %d sec\n\n",updatetime);
        printw("  u         set new updatetime\n");
        printw("  c         CPU-verbose on/off\n");
        printw("  m         mem-verbose on/off\n");
        printw("  s         swap on/verbose/off\n");
        printw("  n         net-verbose on/off\n");
        printw("  h         Help\n");
        printw("  q         Quit\n\n\n");
        printw("\nTo leave this help Window hit any key.\n");
        move(11,2);
        c = -1;
        do
        {
          halfdelay(50);
          c=getch();
        }while(c < 0);
      }
      break;
                  
      case 'n': { 
        if(FALSE == flags.net_verbose)
          flags.net_verbose = TRUE;
        else
          flags.net_verbose = FALSE;
      }
      break;
      case 'u': {
        printw("Change updatetime from %d to: ", updatetime);
        echo();
        scanw("%3d", &old_updatetime);
        noecho();
      }
      break;
      case 'c': {
        if(FALSE == flags.cpu_load_verbose)
          flags.cpu_load_verbose = TRUE;
        else
          flags.cpu_load_verbose = FALSE;
      }
      break;
      case 'm': {
        if(FALSE == flags.mem_verbose)
          flags.mem_verbose = TRUE;
        else
          flags.mem_verbose = FALSE;
      }
      break;
      case 's': {
        swap_state(&pos_swaptotal, &pos_swapfree, &flags);
        if(FALSE == flags.swap_flag)
          flags.swap_flag = TRUE;
        else
        {  
          if(FALSE == flags.swap_verbose)
            flags.swap_verbose = TRUE;
          else
          {
            flags.swap_flag = FALSE;
            flags.swap_verbose = FALSE;
          }
        }
      }
      break;
                  
      default:  {
        printw("Unknown command - try 'h' for help ");
        refresh();
        sleep(3);
        old_updatetime = updatetime;
        updatetime = 3;
      }
    }
    
    clear();
  } //END while
  endwin();
  return 0;
} // END MAIN
