/*
 * ShIT - Shell Information tool
 *--------------------
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */


  
       /********************************************************************
         Currently active programmers:     Philipp Rosenberger (iluminat23) 
                                           Maic Bergmann                   
        ********************************************************************/

 
       
             
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <ncurses.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#define DEFAULTUPDATETIME 1
#define PRGVERSION "0.0.5"
#define TRUE 1
#define FALSE 0 
#define CPU_WARNINGTEMP 75
#define MODUS ,0755)




//===============================================DEKLARATIONS===============================================================


//deklarations of option-switch funktions
void switch_help(void);
void switch_verbose(void);
void switch_foobar(void);
void switch_version(void);
void switch_updatetime(void);
unsigned short switch_cputemp(void);
void switch_setWarnTemp(void);
unsigned short switch_disk_free(void);
unsigned short switch_ppp(void);
unsigned short switch_clear_ppp(void);
unsigned short switch_cpu_load_verbose(void);

//deklarations of output funktions
void head(void);
void uptime(void);
void kernel_v(void);
void cpumodel(void);
unsigned short cputemp(unsigned short);
void memory(void);
void save_custom_Variables(int var);
void get_custom_Variables(unsigned short);
void commit_GetCPUWarnTemp(void);
void cpu_load(unsigned short);
void chk_ShITDir(void);
void disk_free(void);
void net(void);
void net_stat(void);
void ppp(void);
unsigned short ppp_state(unsigned short);
void ppp_clear(void);

//Global Variables
unsigned int CPU_WarningTemp = CPU_WARNINGTEMP;
unsigned int updatetime = DEFAULTUPDATETIME;
unsigned int old_kernel = FALSE;
unsigned int cpumodel_check = TRUE;
unsigned int user_old=0, nice_old=0, system_old=0, idle_old=0;
unsigned int wa_old=0, hi_old=0, si_old=0;

unsigned long long *eth_ptr_rx_old=0, *eth_ptr_tx_old=0, *eth_ptr_rx=0, *eth_ptr_tx=0;
unsigned long long *ppp_ptr_rx_old=0, *ppp_ptr_tx_old=0, *ppp_ptr_rx=0, *ppp_ptr_tx=0, *ppp_ptr_volume_down=0, *ppp_ptr_volume_up=0, ppp_rx_new, ppp_tx_new, *ppp_ptr_rx_volume=0, *ppp_ptr_tx_volume=0, *ppp_ptr_total_rx_volume=0, *ppp_ptr_total_tx_volume=0;


unsigned short eth_num_max, first_run=TRUE, ppp_num_max, start = FALSE;
unsigned char cpumodel_save[50], GetCPUWarnTemp[35], Linux_v[40], *homedir;


//structures
struct tm *tmnow;

//===================================================SWITCH-FUNCTIONS======================================================

//SWITCH HELP output options
void switch_help(void)
{
  //drawing the help-menu
  printf("\n\n>>>shit is a versatile infomonitor<<<\n");
  printf("  usage: shit [option 0] [option 1]...[option n] \n\n");
  printf("  option          long option              meaning\n");
  printf("----------------------------------------------------------------------------------\n");
  printf("  -h, -?           --help                  shows this message\n");
  printf("  -v               --version               shows current Version\n");
  printf("  -f               --foobar                shows FooBar\n");
  printf("  -u               --updatetime            set new updatetime (default: %d sec)\n", DEFAULTUPDATETIME);
  printf("  -ct              --cputemp               shows CPU-Temp in C \n");
  printf("  -st              --settemp               set CPU Warning Temperature (default: %d C)\n", CPU_WARNINGTEMP);
  printf("  -df              --diskfree              shows used disk space\n");
  printf("  -ppp                                     aktivate ppp-load and log\n");
  printf("  -pc              --ppp-clr               clears ppp_volume log-file\n");
  printf("  -cv              --cpu-verbose           verbose cpu-load information\n");
  
  //program does not start if help or wrong option is set
  exit(0);
} //END HELP


// #################################################################################################################


void switch_foobar(void)
{
  printf(">> foobar ;)\n");
} //END switch_foobar


// #################################################################################################################


void switch_version(void)
{
  printf(">> ShIT Version: %s\n", PRGVERSION);
} //END switch_version


// #################################################################################################################


void switch_updatetime(void)
{
//printf("aktuell: %s   n = %i \n\n", argv[n], n); -> DEBUG
  printf("Please enter time (sec) between update: ");
  scanf("%10i", &updatetime);
  if(1 > updatetime)
    updatetime = 1;
  start = TRUE;
} //END switch_updatetime


// #################################################################################################################


unsigned short switch_cputemp(void)
{
  unsigned short cputemp_flag = TRUE;
  start = TRUE;
  
  return cputemp_flag;
} //END switch_cputemp


// #################################################################################################################


void switch_setWarnTemp(void)
{
  printf("Please enter new CPU Warning Temperature in C: ");
  scanf("%3d", &CPU_WarningTemp);
  printf("CPU Warning Temperature Set! (%d C)\n", CPU_WarningTemp);
  start = TRUE;
  
  // Saving the custom CPU Warning Temperature
  save_custom_Variables(CPU_WarningTemp);
  
 }// END switch_setWarnTemp

 
 unsigned short switch_disk_free(void)
{
  unsigned short disk_flag = TRUE;
  start = TRUE;
  
  return disk_flag;
} //END switch_disk_free


unsigned short switch_ppp(void)
{
  unsigned short ppp_flag = TRUE;
  
  start = TRUE;
  return ppp_flag;
}//END switch_ppp

unsigned short switch_clear_ppp(void)
{
  unsigned short ppp_clear_flag = TRUE;
  
  start = TRUE;
  return ppp_clear_flag;
  
}

unsigned short switch_cpu_load_verbose(void)
{
  unsigned short cpu_load_verbose = TRUE;
  start = TRUE;
  return cpu_load_verbose;
}

//***************************************************check dir/file**************************************************************

int exist_directory(const char *Path)
{
     struct stat StatBuf;

     if(stat(Path,&StatBuf)==0)
     {
           switch(StatBuf.st_mode & S_IFMT)
           {
               case S_IFDIR: return(TRUE);
               case S_IFREG:
               case S_IFLNK:
               default: return(FALSE);
           }
     }
     return(FALSE);
}

//====================================================== sysfunctions========================================================

void head(void)
{
  time_t tnow;

  time(&tnow);
  tmnow = localtime(&tnow);  
  printw("\n%02d.%02d.%04d                   [ShIT %s]                        %02d:%02d \n", tmnow -> tm_mday,
                                                                                           tmnow -> tm_mon + 1,
                                                                                           tmnow -> tm_year + 1900,
                                                                                           PRGVERSION,
                                                                                           tmnow -> tm_hour,
                                                                                           tmnow -> tm_min);
  printw("======================================================================\n\n");
} //END head


// #################################################################################################################


void save_custom_Variables(int var) 
{  
  char CPUWarnTempSave[5], custom_Variables_path[100];;
  FILE *save_Variables_file;
     
  strcpy(custom_Variables_path, homedir);
  strcat(custom_Variables_path, "/shit.save");
 
 //opening the file
  save_Variables_file=fopen(custom_Variables_path, "w+");
  
  
//---CPUWARNTEMP----

 //saving the CPU Warning Temperature in the Sysinfo-Settingfile
  fputs("CPU Warning Temp in C: ", save_Variables_file );
  
 //converting int to string
  sprintf(CPUWarnTempSave, "%d", CPU_WarningTemp); 
 
  fputs(CPUWarnTempSave, save_Variables_file);
  fputs("\n", save_Variables_file);
    
//--END CPUWARNTEMP---- 
  

  
 //closing the setting-file   
  fclose(save_Variables_file);   
}// save_custom_Variables


// #################################################################################################################


void get_custom_Variables(unsigned short cputemp_flag)
{
  //Enter number of settings to get
  //int SettingsToGet = 1;  
  char custom_Variables_path[100];
  FILE*get_Variables_file;
  
  strcpy(custom_Variables_path, homedir);
  strcat(custom_Variables_path, "/shit.save");
  get_Variables_file=fopen(custom_Variables_path, "r");
 
  if(NULL != get_Variables_file)
  {
    if(TRUE == cputemp_flag)
    {
      fgets(GetCPUWarnTemp, 35, get_Variables_file );  //Get CPU Warning Temperature
      commit_GetCPUWarnTemp();
    //add anotherone here!
    }
  }
  else 
  {
   
    printf("\nNo config-file found or config-file corrupt!\n\nPlease start shit with -st option to create a new config file.\n\n");
  /*printw("No config-file found or config-file corrupt!\t\t\t\t\t\t\t[WARNING]\n* Please type \"sysinfo_config\" \
  to create a new config-file\n\n");*/
   
   //end program if no config-file was found
   exit(0);
 }
}


// #################################################################################################################


void uptime(void)
{
  unsigned int uptime_unsorted = 0;
  unsigned char c;
  unsigned int DD;
  unsigned int HH;
  unsigned int MM;
//unsigned int SS; //uptime seconds
  FILE *uptime_file;  

  uptime_file=fopen("/proc/uptime","r");

  if(NULL != uptime_file)
  {  
    while((c=fgetc(uptime_file))!= '.')
      {
        unsigned int i;
        i = atoi(&c);
      //uptime unsorted == uptime in seconds
        uptime_unsorted = (uptime_unsorted * 10) + i;
      }
    
    //SS = uptime_unsorted % 60; 
    MM = uptime_unsorted / 60;
    HH = MM / 60;
    HH = HH % 24;
    DD = uptime_unsorted / (60 * 60 * 24);
    
    MM = MM % 60;

    fclose(uptime_file);
    if(0 != DD)
      printw("Uptime:\t\t%id %02ih %02im\n",DD,HH,MM);
    else
    {  
      if(0 != HH)
        printw("Uptime:\t\t%ih %02im\n",HH,MM);
      else
        printw("Uptime:\t\t%im\n",HH,MM);
    }
  }
  else
  {
    printw("Open file \"proc/uptime\" failed!\n");
  }

} //end UPTIME


// #################################################################################################################


void kernel_v(void)
{
  if(TRUE == first_run)
  {
    FILE *kernel_file;
    kernel_file=fopen("/proc/sys/kernel/osrelease", "r");
  
    if(NULL != kernel_file)
    { 
      fgets(Linux_v, 35, kernel_file);
      printw("Linux:\t\t%s",Linux_v); 
    
      if(strstr(Linux_v, "2.6") == NULL )
        old_kernel = TRUE;
    
      fclose(kernel_file);
    }
    else
    {
      char trash[30];
      kernel_file=fopen("/proc/version", "r");
      fscanf(kernel_file, "%s%s%s",trash ,trash ,Linux_v);
      strcat(Linux_v, "\n");

      printw("Linux:\t\t%s",Linux_v);
    
      if(strstr(Linux_v, "2.6") == NULL )
        old_kernel = TRUE;

      fclose(kernel_file);
    }
  }
  else
  {
    printw("Linux:\t\t%s",Linux_v);
  }
} //END detect Kernel version and output


// #################################################################################################################


void memory(void)
{
  char MemTotal[35];
  char MemFree[35];
  FILE *mem_file;
  
  mem_file=fopen("/proc/meminfo","r");
  
  if(NULL != mem_file)
  {
    if(old_kernel == TRUE)
    {
      unsigned char trash[100];
      unsigned int i;
      for(i=3; i>0 ; i--)
        fgets(trash, 100, mem_file);
    }
    
    fgets(MemTotal, 35, mem_file);
    fgets(MemFree, 35, mem_file);
    printw("%s",MemTotal);
    printw("%s",MemFree);
    fclose(mem_file);
  }
  else
  {
    printw("Open file \"/proc/meminfo\" failed!\n");
  }
}//END memory


// #################################################################################################################


unsigned short cputemp(unsigned short temp_device_flag)
{ 
  char cputemp_string[35];
  char num[] ="0123456789";
  char cputemp_char;
  unsigned int temp = 0;
  unsigned int tempbegin;
  unsigned int tempend;
  unsigned int cputemp = 0;
  char path[45];
  FILE *cputemp_file;
  
  if(1 > temp_device_flag)
  {
    cputemp_file=fopen("/sys/bus/i2c/devices/0-0290/temp1_input", "r");
    if(NULL != cputemp_file)
    {
      temp_device_flag = 1;
      fclose(cputemp_file);
    }
  
    cputemp_file=fopen("/proc/acpi/thermal_zone/ATF0/temperature", "r");
    if(NULL != cputemp_file)
    {
      temp_device_flag = 2;
      fclose(cputemp_file);
    }
  
    cputemp_file=fopen("/proc/acpi/thermal_zone/THRM/temperature","r");
    if(NULL != cputemp_file)
    {
      temp_device_flag =3;
      fclose(cputemp_file);
    }
  }//END if  
  switch (temp_device_flag)
  {
    case 3: strncpy (path,"/proc/acpi/thermal_zone/THRM/temperature",sizeof(path));
            break;
    case 2: strncpy(path, "/proc/acpi/thermal_zone/ATF0/temperature", sizeof(path));
            break;
    case 1: break;
    default: printw("CPU-Temp:\tNo sensors found!\n");   
     
  }
  
  if(1 < temp_device_flag)
  {
    cputemp_file=fopen(path, "r");
    fgets(cputemp_string, 35, cputemp_file);
    
  //strpbrk(cputemp, num);
  //temp = atoi(&cputemp);
       
    tempbegin = strcspn(cputemp_string, num);
    tempend = strcspn(cputemp_string, "C");
    
    int i = tempbegin;
    for (; i < (tempend-1); i++)
    {
      cputemp_char = cputemp_string[i];
      temp = (((int)cputemp_char)- 48);
      cputemp = (cputemp * 10) + temp;
    }
    
    //printw("%d", CPU_WarningTemp);
    
    if (cputemp < CPU_WarningTemp)
    {   
      printw("CPU-Temp:\t%d C\n",cputemp);
    }  
    else  
    {
      printw("CRITICAL CPU TEMPERATURE !!! (%d C)\n", cputemp);
    }
    
     fclose(cputemp_file);
     
  }
  else if(1 == temp_device_flag)
    {
      cputemp_file=fopen("/sys/bus/i2c/devices/0-0290/temp1_input", "r");
      fgets(cputemp_string, 7, cputemp_file);
      int i = 0;
      for( ;i < 5; i++)
      {
        cputemp_char = cputemp_string[i];
        temp = (((int)cputemp_char)- 48);
        cputemp = (cputemp * 10) + temp;
      }
      cputemp /= 1000;
      if (cputemp < CPU_WarningTemp)
      {   
        printw("CPU-Temp:\t%d C\n",cputemp);
      }  
      else  
      {
        printw("CRITICAL CPU TEMPERATURE !!! (%d C)\n", cputemp);
      }
      
      fclose(cputemp_file);
    }
  
  return temp_device_flag;
} //END cputemp


// #################################################################################################################
 

void commit_GetCPUWarnTemp(void)
{
  unsigned int WarnTempbegin = 0;
  unsigned int i;
  unsigned int WarnTempend;
  unsigned char WarnTempChar; 
  unsigned int temp;
  unsigned int tempnew = 0;
  
  WarnTempbegin = strcspn( GetCPUWarnTemp, ":") + 2;
  WarnTempend = WarnTempbegin + 2;    // Two digits
 
  
  for (i = WarnTempbegin ; i < (WarnTempend); i++)
  {
    WarnTempChar = GetCPUWarnTemp[i];
    temp = (((int)WarnTempChar)- 48);
    tempnew = (tempnew * 10) + temp;
   }
  
   CPU_WarningTemp = tempnew;      
}


// #################################################################################################################


void cpumodel(void)
{
  FILE *cpumodel_file;
  
  if (cpumodel_check == TRUE) // already ascertained the model?
  {
    char cpumodel[50], cpuinfo[50], trash[100];
    int cpubegin;
    
    cpumodel_file=fopen("/proc/cpuinfo", "r");
  
    if(NULL != cpumodel_file)
    {
      int i;
      for (i = 4; i > 0; i--)
        fgets(trash, 100, cpumodel_file);
    
      
      fgets(cpuinfo, 50, cpumodel_file);
      fclose(cpumodel_file);
  
      //Allocating the first CPU-Model Character
      cpubegin = strcspn( cpuinfo, ":") + 2;
      
  
      i = cpubegin; 
      for (; cpubegin < 50; cpubegin ++)
        cpumodel[cpubegin - i] = cpuinfo[cpubegin];

    
      //Display the CPU-Model
      printw("CPU-Model:\t%s", cpumodel);
    }
    else
    {
      fclose(cpumodel_file);
      printw("Open file \"/proc/cpuinfo\" failed!\n");
    }
    
    cpumodel_check = FALSE;
    strcpy(cpumodel_save , cpumodel); 
  }
  
  else
    printw("CPU-Model:\t%s", cpumodel_save); //Printing CPU - Model from Memory
    
}// END cpumodel


// #################################################################################################################


void cpu_load(unsigned short cpu_load_verbose)
{
  FILE *cpu_load_file;
  int user_new, nice_new, system_new, idle_new, wa_new, hi_new, si_new;
  int user = 0, nice = 0, system=0, idle=0;
  int wa=0, hi=0, si = 0;
  char cpu[6];
  
  cpu_load_file=fopen("/proc/stat","r");
  
  if(NULL != cpu_load_file)
  {
    fscanf(cpu_load_file,"%s%d%d%d%d%d%d%d\n",cpu,&user_new,&nice_new,&system_new,&idle_new,&wa_new,&hi_new,&si_new);
  
    printf("debug1\n");
    if(TRUE == cpu_load_verbose)
    {
      user = user_new - user_old;
      nice = nice_new - nice_old;
      system = system_new - system_old;
      idle = idle_new - idle_old;
      wa = wa_new - wa_old;
      hi = hi_new - hi_old;
      si = si_new - si_old;
    
      if(1 < updatetime)
      {
        user /= updatetime;
        nice /= updatetime;
        system /= updatetime;
        idle /= updatetime;
        wa /= updatetime;
        hi /= updatetime;
        si /= updatetime;
      }
    
      if(TRUE == first_run)
        printw("CPU-Load:\tuser:\t0\%\n\t\tsys:\t0\%\n\t\tnice:\t0\%\n\t\tidle:\t0\%\n\t\twa:\t0\%\n\t\thi:\t0\%\n\t\tsi:\t0\% \n");
    
      if(0 != user_old)
        printw("CPU-Load:\tuser:\t%d\%\n\t\tsys:\t%d\%\n\t\tnice:\t%d\%\n\t\tidle:\t%d\%\n\t\twa:\t%d\%\n\t\thi:\t%d\%\n\t\tsi:\t%d\% \n",user,system, nice, idle, wa, hi, si);
    
      user_old = user_new;
      nice_old = nice_new;
      system_old = system_new;
      idle_old = idle_new;
      wa_old = wa_new;
      hi_old = hi_new;
      si_old = si_new;
    }
    else
    {
      user = user_new - user_old;
      nice = nice_new - nice_old;
      system = system_new - system_old;
      idle = idle_new - idle_old;
    
      if(1 < updatetime)
      {
        user /= updatetime;
        nice /= updatetime;
        system /= updatetime;
        idle /= updatetime;
      }
    
      if(TRUE == first_run)
        //printw("CPU-Load:\tuser:\t 0\%\n\t\tsys:\t 0\%\n\t\tnice:\t 0\%\n\t\tidle:\t 0\%\n");
        printw("CPU-Load:\t0%%  ");
      if(0 != user_old)
      //  printw("CPU-Load:\tuser:\t%2d\%\n\t\tsys:\t%2d\%\n\t\tnice:\t%2d\%\n\t\tidle:\t%2d\%\n",user,system, nice, idle);
      printw("CPU-Load:\t%d%%  ",(100-idle));
      int i = (100 - idle)/5;
      for(;i > 0; i--)
        printw("=");
      printw(">\n");

      user_old = user_new;
      nice_old = nice_new;
      system_old = system_new;
      idle_old = idle_new;
    }
    fclose(cpu_load_file);
  }
}


// #################################################################################################################

void chk_ShITDir(void)
{  
  unsigned short homedir_flag;
  homedir_flag = exist_directory(homedir);
  if (FALSE == homedir_flag)
  {
    //Creating new Sysinfo Directory
    if(mkdir(homedir MODUS == -1) /*Nicht schn, aber portabler*/
    {
      printf("could not create \"%s\"\n",homedir);
      exit(0);
    }
  }
}

// ##################################################################################################################

void disk_free(void)
{
  FILE *df_file;
  char df_tmp[254]= "";
  char df_path[200];
  short eof_flag = 0;
  system("df -hl > ~/df");
  strcpy(df_path, homedir);
  strcat(df_path, "/df");
  df_file = fopen(df_path,"r");
  if(NULL != df_file)
  {
    while(0 == eof_flag)
    {
      printw("%s",df_tmp);
      fgets(df_tmp, 250, df_file);
      eof_flag = feof(df_file);
    }
    fclose(df_file);
  }
}

// ###################################################################################################################

void net_stat(void)
{
  FILE *net_file;
  net_file = fopen("/proc/net/dev","r");
  int eth_num=0;
  if(NULL != net_file)
  { 
    int i, end=0;
    char trash[200], eth[200];
    
    for(i=0; i<2; i++)
      fgets(trash, 200, net_file);
        
    while(0 == end)
    {  
      fgets(eth, 200, net_file);
      i = strncmp("  eth",eth, 4);
      
      if(0==i)
      {
        eth_num++;
        i=1;
      }
      
      eth[0] = '\0';
      end = feof(net_file);
    }
    fclose(net_file);
        
    eth_ptr_rx_old=(unsigned long long *)malloc(eth_num * sizeof(*eth_ptr_rx_old));
    if(NULL == eth_ptr_rx_old)
      printw("No memory available");
      
    eth_ptr_tx_old=(unsigned long long *)malloc(eth_num * sizeof(*eth_ptr_tx_old));
    if(NULL == eth_ptr_tx_old)
      printw("No memory available");
      
    eth_ptr_rx=(unsigned long long *)malloc(eth_num * sizeof(*eth_ptr_rx));
    if(NULL == eth_ptr_rx)
      printw("No memory available");
      
    eth_ptr_tx=(unsigned long long *)malloc(eth_num * sizeof(*eth_ptr_tx));
    if(NULL == eth_ptr_tx)
      printw("No memory available");
  }
  eth_num_max = eth_num - 1;
}

void net(void)
{
  FILE *net_file;
  net_file = fopen("/proc/net/dev","r");
  char eth[200], dev[10]={0}, *ptr_char;
  int i,end=0, trash_int, eth_num=0;
  unsigned long long eth_rx_new, eth_tx_new;
  
  if(NULL != net_file)
  {
    while(0 == end)
    {
      fgets(eth, 200, net_file);
      i = 1;
      i = strncmp("  eth",eth, 4);
      if(0 == i)
      {
        ptr_char = strtok(eth,":");
        strcpy(dev, ptr_char);
        ptr_char = strtok(NULL,":");
        strcpy(eth, ptr_char);
        sscanf(eth, "%lld%i%i%i%i%i%i%i%lld",&eth_rx_new,&trash_int,&trash_int,&trash_int, &trash_int\
                                        ,&trash_int,&trash_int,&trash_int,&eth_tx_new);
        if(FALSE == first_run)
        {
          eth_ptr_rx[eth_num] = eth_rx_new - eth_ptr_rx_old[eth_num];
          eth_ptr_tx[eth_num] = eth_tx_new - eth_ptr_tx_old[eth_num];
        }
        
        eth_ptr_rx_old[eth_num] = eth_rx_new;
        eth_ptr_tx_old[eth_num] = eth_tx_new;
        
        eth_num++;
      }
    
    eth[0] = '\0';
    end = feof(net_file);
    }
    fclose(net_file);
  }
  else
  {
    printw("Open file \"/proc/net/dev\" failed!\n");
  }
  
  for(i=0;i <= eth_num_max; i++)
  {
    char unit_rx[5]="B", unit_tx[5]="B";
    
    if(1 < updatetime)
    {
      eth_ptr_rx[i] /= updatetime;
      eth_ptr_tx[i] /= updatetime;
    }
    
    if(1024 < eth_ptr_rx[i])
      {
        strcpy(unit_rx,"KB");
        eth_ptr_rx[i] /= 1024;
        
        if(1024 < eth_ptr_rx[i])
        {
          strcpy(unit_rx,"MB");
          eth_ptr_rx[i] /= 1024;
        }
      }
    
    if(1024 < eth_ptr_tx[i])
      {
        strcpy(unit_tx,"KB");
        eth_ptr_tx[i] /= 1024;
        
        if(1024 < eth_ptr_tx[i])
        {
          strcpy(unit_tx,"MB");
          eth_ptr_tx[i] /= 1024;
        }
      }
    
    if(TRUE == first_run)
      printw("eth%i:\t\tRX:\t0 B/s\n\t\tTX:\t0 B/s\n",i);
    else
      printw("eth%i:\t\tRX:\t%lld %s/s\n\t\tTX:\t%lld %s/s\n",i,eth_ptr_rx[i],unit_rx,eth_ptr_tx[i],unit_tx);
  }
}

void ppp(void)
{
  FILE *ppp_file, *ppp_volume_file;
  ppp_file = fopen("/proc/net/dev","r");
  char ppp[200], dev[10]={0}, *ptr_char, ppp_volume_path[100];
  int i,end=0, trash_int, ppp_num=0;
  
  strcpy(ppp_volume_path, homedir);
  strcat(ppp_volume_path, "/ppp_volume");
  
  if(NULL != ppp_file)
  {
    while(0 == end)
    {
      fgets(ppp, 200, ppp_file);
      i = 1;
      i = strncmp("  ppp",ppp, 4);
      if(0 == i)
      {
        ptr_char = strtok(ppp,":");
        strcpy(dev, ptr_char);
        ptr_char = strtok(NULL,":");
        strcpy(ppp, ptr_char);
        sscanf(ppp, "%lld%i%i%i%i%i%i%i%lld",&ppp_rx_new,&trash_int,&trash_int,&trash_int, &trash_int\
                                            ,&trash_int,&trash_int,&trash_int,&ppp_tx_new);
         
         if(FALSE == first_run)
         {
           ppp_ptr_rx[ppp_num] = ppp_rx_new - ppp_ptr_rx_old[ppp_num];
           ppp_ptr_tx[ppp_num] = ppp_tx_new - ppp_ptr_tx_old[ppp_num];
           if(1 < updatetime);
           {
             ppp_ptr_rx[ppp_num] /= updatetime;
             ppp_ptr_rx[ppp_num] /= updatetime;
           }
         }
        if(TRUE == first_run)
        {
          ppp_ptr_rx_volume[ppp_num] = ppp_rx_new;
          ppp_ptr_tx_volume[ppp_num] = ppp_tx_new;
        }
        
        ppp_ptr_rx_old[ppp_num] = ppp_rx_new;
        ppp_ptr_tx_old[ppp_num] = ppp_tx_new;
        
        //calculate volume (new-volume - old-volume + volume-from-file)
        ppp_ptr_total_rx_volume[ppp_num] = ppp_rx_new - ppp_ptr_rx_volume[ppp_num] + ppp_ptr_volume_down[ppp_num];
        ppp_ptr_total_tx_volume[ppp_num] = ppp_tx_new - ppp_ptr_tx_volume[ppp_num] + ppp_ptr_volume_up[ppp_num];
        ppp_num++;
      }
    
    ppp[0] = '\0';
    end = feof(ppp_file);
    }
    fclose(ppp_file);
  }
  else
  {
    printw("Open file \"/proc/net/dev\" failed!\n");
  }
  
  if(ppp_num_max > 5)
    printw("no ppp in \"/proc/net/dev\" found!");
  else
  {
    ppp_volume_file = fopen(ppp_volume_path,"w");   
    if(NULL != ppp_volume_file)
    {
      for(i=0;i <= ppp_num_max; i++)
      {
        char unit_rx[5]="B", unit_tx[5]="B", unit_rx_volume[5]="B", unit_tx_volume[5]="B", unit_total_volume[5]="B";
        unsigned long long ppp_rx_volume_display, ppp_tx_volume_display,ppp_total_volume_display;
        
        ppp_rx_volume_display = ppp_ptr_total_rx_volume[i];
        ppp_tx_volume_display = ppp_ptr_total_tx_volume[i];
        
        if(updatetime > 1)
        {
          ppp_ptr_rx[i] /= updatetime;
          ppp_ptr_tx[i] /= updatetime;
        }
        
        if(1024 < ppp_ptr_rx[i])
        {
          strcpy(unit_rx,"KB");
          ppp_ptr_rx[i] /= 1024;
        }
        if(1024 < ppp_ptr_rx[i])
        {
          strcpy(unit_rx,"MB");
          ppp_ptr_rx[i] /= 1024;
        }
        
        if(1024 < ppp_ptr_tx[i])
        {
          strcpy(unit_tx,"KB");
          ppp_ptr_tx[i] /= 1024;
        }
        if(1024 < ppp_ptr_tx[i])
        {
          strcpy(unit_tx,"MB");
          ppp_ptr_tx[i] /= 1024;
        }
        
        if(TRUE == first_run)
          printw("eth%i:\t\tRX:\t0 B/s\n\t\tTX:\t0 B/s\n",i);
        else
          printw("ppp%i:\t\tRX:\t%lld %s/s\n\t\tTX:\t%lld %s/s\n",i,ppp_ptr_rx[i], unit_rx, ppp_ptr_tx[i], unit_tx);
        
        if(1024 < ppp_rx_volume_display)
        {
          strcpy(unit_rx_volume,"KB");
          ppp_rx_volume_display /= 1024;
        }
        if(1024 < ppp_rx_volume_display)
        {
          strcpy(unit_rx_volume,"MB");
          ppp_rx_volume_display /= 1024;
        }
        
        if(1024 < ppp_tx_volume_display)
        {
          strcpy(unit_tx_volume,"KB");
          ppp_tx_volume_display /= 1024;
        }
        if(1024 < ppp_tx_volume_display)
        {
          strcpy(unit_tx_volume,"MB");
          ppp_tx_volume_display /= 1024;
        }
        
        printw("\t\tdown:\t%lld %s\n\t\tup:\t%lld %s\n",ppp_rx_volume_display, unit_rx_volume, ppp_tx_volume_display, unit_tx_volume);
        
        ppp_total_volume_display = (ppp_ptr_total_rx_volume[i] + ppp_ptr_total_tx_volume[i]);
        
        if(1024 < ppp_total_volume_display)
        {
          strcpy(unit_total_volume,"KB");
          ppp_total_volume_display /= 1024;
        }
        if(1024 < ppp_total_volume_display)
        {
          strcpy(unit_total_volume,"MB");
          ppp_total_volume_display /= 1024;
        }

        printw("\t\ttotal:\t%lld %s\n",ppp_total_volume_display, unit_total_volume);
        
        fprintf(ppp_volume_file,"ppp%i:\n%lld downloaded (Byte)\n%lld uploaded (Byte)\n", i, ppp_ptr_total_rx_volume[i], ppp_ptr_total_tx_volume[i]);
      }

    fclose(ppp_volume_file);
    }
  }
}


unsigned short ppp_state(unsigned short ppp_exist)
{
  FILE *ppp_file, *ppp_volume_file;
  
  int ppp_num=0;
  
  ppp_file = fopen("/proc/net/dev","r");
  if(NULL != ppp_file)
  { 
    int i, end=0;
    char trash[200], ppp[200];
//DEBUG
  //printw("test2\n");
      for(i=0; i<2; i++)              //redas hedline and do it in trash
      fgets(trash, 200, ppp_file);
        
    while(0 == end)
    {  
      fgets(ppp, 200, ppp_file);    
      i = strncmp("  ppp",ppp, 4);    //
//DEBUG
  //printw("test3\n");
      if(0==i)
      {
//DEBUG
  //printw("test4\n");
        ppp_exist=TRUE;
        ppp_num++;
        i=1;
      }
      
      ppp[0] = '\0';
      end = feof(ppp_file);
    }
//DEBUG
  //printw("test4\n");
    fclose(ppp_file);
    if(0 < ppp_num)
    {
      ppp_ptr_rx_old=(unsigned long long *)malloc(ppp_num * sizeof(*ppp_ptr_rx_old));
      if(NULL == ppp_ptr_rx_old)
        printw("No memory available");
      
      ppp_ptr_tx_old=(unsigned long long *)malloc(ppp_num * sizeof(*ppp_ptr_tx_old));
      if(NULL == ppp_ptr_tx_old)
        printw("No memory available");
      
      ppp_ptr_rx=(unsigned long long *)malloc(ppp_num * sizeof(*ppp_ptr_rx));
      if(NULL == ppp_ptr_rx)
        printw("No memory available");
      
      ppp_ptr_tx=(unsigned long long *)malloc(ppp_num * sizeof(*ppp_ptr_tx));
      if(NULL == ppp_ptr_tx)
        printw("No memory available");
      
      ppp_ptr_volume_down=(unsigned long long *)malloc(ppp_num * sizeof(*ppp_ptr_volume_down));
      if(NULL == ppp_ptr_volume_down)
        printw("No memory available");
      
      ppp_ptr_volume_up=(unsigned long long *)malloc(ppp_num * sizeof(*ppp_ptr_volume_up));
      if(NULL == ppp_ptr_volume_up)
        printw("No memory available");
      
      ppp_ptr_rx_volume=(unsigned long long *)malloc(ppp_num * sizeof(*ppp_ptr_rx_volume));
      if(NULL == ppp_ptr_rx_volume)
        printw("No memory available");
      
      ppp_ptr_tx_volume=(unsigned long long *)malloc(ppp_num * sizeof(*ppp_ptr_tx_volume));
      if(NULL == ppp_ptr_tx_volume)
        printw("No memory available");
      
      ppp_ptr_total_rx_volume=(unsigned long long *)malloc(ppp_num * sizeof(*ppp_ptr_total_rx_volume));
      if(NULL == ppp_ptr_total_rx_volume)
        printw("No memory available");
        
      ppp_ptr_total_tx_volume=(unsigned long long *)malloc(ppp_num * sizeof(*ppp_ptr_total_tx_volume));
      if(NULL == ppp_ptr_total_tx_volume)
        printw("No memory available");
    }
    else
    {
      return ppp_exist = FALSE;
    }
    
//DEBUG
  //printw("test5\n");
  
    ppp_num_max = ppp_num - 1;
    char ppp_volume_path[100];
    strcpy(ppp_volume_path, homedir);
    strcat(ppp_volume_path, "/ppp_volume");
    //ppp_volume_file = fopen(ppp_volume_path,"r");
    ppp_volume_file = fopen(ppp_volume_path,"r");
//DEBUG
  //printw("test6\n");
    
    if(NULL != ppp_volume_file)
    {

//DEBUG
  //printw("test7\n");
      
      for(i=0;i <= ppp_num_max; i++)
      {

//DEBUG
  //printw("test7\n");
        
        char trash_char[20];
        fscanf(ppp_volume_file,"%10s\n",trash_char);
        fscanf(ppp_volume_file,"%lld%10s%10s\n",&ppp_ptr_volume_down[i], trash_char, trash_char);
        fscanf(ppp_volume_file,"%lld%10s%10s\n",&ppp_ptr_volume_up[i],trash_char,trash_char);
        //end = feof(ppp_volume_file);
      }
      fclose(ppp_volume_file);
    }
    else
    {
      FILE *ppp_volume_file;
      strcpy(ppp_volume_path, homedir);
      strcat(ppp_volume_path, "/ppp_volume");
      
      ppp_volume_file = fopen(ppp_volume_path,"w+");
      if(NULL != ppp_volume_file)
      {
        int i;
        for(i=0;i <= ppp_num_max; i++)
        {
          fprintf(ppp_volume_file,"ppp%i:\n0 downloaded (Byte)\n0 uploaded (Byte)\n",i);
          ppp_ptr_volume_down[i] = 0;
          ppp_ptr_volume_up[i] = 0;
        }
        fclose(ppp_volume_file);
      }
    }
  }
  return ppp_exist = TRUE;
}//END ppp_state

void ppp_clear(void)
{
  FILE *ppp_volume_file;
  char ppp_volume_path[130];
  strcpy(ppp_volume_path, homedir);
  strcat(ppp_volume_path, "/ppp_volume");
  
  ppp_volume_file = fopen(ppp_volume_path,"w+");
  if(NULL != ppp_volume_file)
  {
    int i;
    for(i=0;i <= ppp_num_max; i++)
    {
      fprintf(ppp_volume_file,"ppp%i:\n0 downloaded (Byte)\n0 uploaded (Byte)\n",i);
      ppp_ptr_volume_down[i] = 0;
      ppp_ptr_volume_up[i] = 0;
    }
    fclose(ppp_volume_file);
  }
  else
  {
    printf("could not write to \"%s\"",ppp_volume_path);
  }
}//END ppp_clear

/*###################################################################################################################
#================================================MAIN===============================================================#
###################################################################################################################*/

int main(int argc, char **argv)
{
  unsigned short cputemp_flag = FALSE, disk_flag=FALSE, ppp_flag=FALSE, ppp_exist, temp_device_flag = 0, ppp_clear_flag=FALSE, cpu_load_verbose=FALSE;
  
  homedir = getenv("HOME");
  strcat(homedir, "/.shit");
  if (argc > 1) // commited argument?
  {  
    unsigned int i;  
    for (i = argc; i > 1; i--)
    {
      int option_n = i-1;
      int x=19; //number of options -1
      
      char * const options[]={"--help","-h",\
                              "--foobar","-f",\
                              "--version","-v",\
                              "--updatetime","-u",\
                              "--cputemp","-ct",\
                              "--settemp","-st",\
                              "--diskfree","-df",\
                              "--ppp","-ppp",\
                              "--ppp-clr","-pc",\
                              "--cpu-verbose","-cv"};

      do
      {
        if((strcmp (argv[option_n],options[x]) == 0)||(0==x))
        {
          switch(x)
          {

            case 19: 
            case 18: cpu_load_verbose = switch_cpu_load_verbose();
                     break;
            case 17: 
            case 16: ppp_clear_flag = switch_clear_ppp();
            case 15:
            case 14: ppp_flag = switch_ppp();
                     break;
            case 13: 
            case 12: disk_flag = switch_disk_free();
                     break;
            case 11: 
            case 10: switch_setWarnTemp();
                     break;
            case 9:
            case 8:  cputemp_flag = switch_cputemp(); 
                     break;
            case 7:
            case 6:  switch_updatetime(); 
                     break;
            case 5:
            case 4:  switch_version();
                     break;
            case 3:
            case 2:  switch_foobar();
                     break; 
            case 1:
            default: switch_help();
          }
  
          x=-1; //all options checked (dropout...)

          if((1>=option_n)&&(0==start)) //if last option is read and the prgramm should not start
          {
            exit(0);      //Program exit
          }
          else      
          {
          // empy else because dangling else problem
          }
        }  
        else
        {
          x-=1;
        }
      }
      while(x > -1);
  
    } //END for
  } //END Arguments  
   
//Cheacking for Sysinfo-Directory
  chk_ShITDir();
  get_custom_Variables(cputemp_flag); //Loding Setting-File
  
  net_stat();
  
  if(TRUE == ppp_flag)
    ppp_exist = ppp_state(ppp_exist);
  
  if(TRUE == ppp_exist)
    if(TRUE == ppp_clear_flag)
      ppp_clear();
    
  initscr();
  noecho();
  
  while(1)
  {
  //drawing the output on screen
    head();
    kernel_v();
    
    uptime();
    
    printw("\n");
    
    cpumodel();
    cpu_load(cpu_load_verbose);
    
    if(TRUE == cputemp_flag)
      temp_device_flag = cputemp(temp_device_flag);
    
    printw("\n");
    
    memory();
    
    printw("\n");
    
    net();
    
    if(TRUE == ppp_flag)
    {
      if(TRUE == ppp_exist)
        ppp();
      else
        printw("no ppp in \"/proc/net/dev\" found!\n");
    }
        
    first_run=FALSE;
    
    if(TRUE == disk_flag)
    {
      printw("\n");
      disk_free();
    }

    refresh();
    char c;    
    halfdelay(updatetime * 10);
    c=getch();
    if(c == 'q')
    {
      endwin();
      exit(0);
    }
    
    clear();
  } //END while
  endwin();
  return 0;
} // END MAIN
